/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general3;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general3.KlingerVolume$Signals;
import com.motivewave.platform.study.general3.KlingerVolume$Values;

@StudyHeader(namespace="com.motivewave", id="ID_KLINGER_VOLUME", rb="com.motivewave.platform.study.nls.strings2", name="NAME_KLINGER_VOLUME_OSCILLATOR", label="LBL_KLVO", desc="DESC_KLINGER", menu="MENU_VOLUME_BASED", helpLink="http://www.motivewave.com/studies/klinger_volume_oscillator.htm", requiresVolume=true, signals=true, overlay=false, studyOverlay=true)
public class KlingerVolume
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("FAST_PERIOD", new Object[0]), 34, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("SLOW_PERIOD", new Object[0]), 55, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("SIGNAL_PERIOD", new Object[0]), 13, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_KLVO", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("SIGNAL", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_KLVO", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SIGNAL", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -9999.1, 9999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        SettingGroup settingGroup5 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("FAST_PERIOD", new Object[0]), 34, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("SLOW_PERIOD", new Object[0]), 55, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period3", this.get("SIGNAL_PERIOD", new Object[0]), 13, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"method", "line", "line2", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"period", "period2", "period3", "method"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)KlingerVolume$Values.KO, this.get("KO", new Object[0]), new String[]{"period", "period2", "method"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)KlingerVolume$Values.KOS, this.get("KOS", new Object[0]), new String[]{"period3", "method"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)KlingerVolume$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)KlingerVolume$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)KlingerVolume$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)KlingerVolume$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)KlingerVolume$Values.KO, "line");
        runtimeDescriptor.declarePath((Object)KlingerVolume$Values.KOS, "line2");
        runtimeDescriptor.declareIndicator((Object)KlingerVolume$Values.KO, "ind");
        runtimeDescriptor.declareIndicator((Object)KlingerVolume$Values.KOS, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{KlingerVolume$Values.KO, KlingerVolume$Values.KOS});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        this.setMinBars(Math.max(n2, n3) + n4 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getHigh(n2);
        double d3 = dataSeries.getLow(n2);
        double d4 = dataSeries.getClose(n2);
        double d5 = dataSeries.getVolume(n2);
        double d6 = dataSeries.getHigh(n2 - 1);
        double d7 = dataSeries.getLow(n2 - 1);
        double d8 = dataSeries.getClose(n2 - 1);
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = dataSeries.getDouble(n2 - 1, (Object)KlingerVolume$Values.CM, 0.0);
        double d12 = d6 - d7;
        int n6 = dataSeries.getInt(n2 - 1, (Object)KlingerVolume$Values.TREND);
        int n7 = -1;
        if (d2 + d3 + d4 > d6 + d7 + d8) {
            n7 = 1;
        }
        double d13 = d2 - d3;
        d10 = n7 == n6 ? d11 + d13 : d12 + d13;
        dataSeries.setDouble(n2, (Object)KlingerVolume$Values.CM, Double.valueOf(d10));
        dataSeries.setInt(n2, (Object)KlingerVolume$Values.TREND, n7);
        d9 = d10 == 0.0 ? -2.0 : Math.abs(2.0 * (d13 / d10 - 1.0));
        double d14 = d5 * d9 * (double)n7 * 100.0;
        dataSeries.setDouble(n2, (Object)KlingerVolume$Values.VF, Double.valueOf(d14));
        if (n2 < Math.max(n3, n4) * 2 + 1) {
            return;
        }
        Double d15 = dataSeries.ma(mAMethod, n2, n3, (Object)KlingerVolume$Values.VF);
        if (d15 == null) {
            return;
        }
        Double d16 = dataSeries.ma(mAMethod, n2, n4, (Object)KlingerVolume$Values.VF);
        if (d16 == null) {
            return;
        }
        Double d17 = d15 - d16;
        dataSeries.setDouble(n2, (Object)KlingerVolume$Values.KO, d17);
        if (n2 < Math.max(n3, n4) * 2 + n5 + 1) {
            return;
        }
        Double d18 = dataSeries.ma(mAMethod, n2, n5, (Object)KlingerVolume$Values.KO);
        if (d18 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)KlingerVolume$Values.KOS, d18);
        boolean bl2 = this.crossedAbove(dataSeries, n2, (Object)KlingerVolume$Values.KO, (Object)KlingerVolume$Values.KOS);
        boolean bl3 = this.crossedBelow(dataSeries, n2, (Object)KlingerVolume$Values.KO, (Object)KlingerVolume$Values.KOS);
        Boolean bl4 = dataSeries.getBoolean(n2, (Object)KlingerVolume$Signals.SELL);
        Boolean bl5 = dataSeries.getBoolean(n2, (Object)KlingerVolume$Signals.BUY);
        dataSeries.setBoolean(n2, (Object)KlingerVolume$Signals.SELL, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)KlingerVolume$Signals.BUY, Boolean.valueOf(bl2));
        if (bl3 && (bl4 == null || bl4 != bl3)) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d17.doubleValue());
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_KLINGER_VOLUME_HIGH_KO", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d17, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)KlingerVolume$Signals.SELL, string, (Object)d2);
        }
        if (bl2 && (bl5 == null || bl5 != bl2)) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d17.doubleValue());
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_KLINGER_VOLUME_LOW_KO", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d17, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)KlingerVolume$Signals.BUY, string, (Object)d3);
        }
        dataSeries.setComplete(n2);
    }
}

