/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general3;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general3.EaseOfMovement$Signals;
import com.motivewave.platform.study.general3.EaseOfMovement$Values;

@StudyHeader(namespace="com.motivewave", id="ID_EASE_OF_MOVEMENT", rb="com.motivewave.platform.study.nls.strings2", name="NAME_EASE_OF_MOVEMENT", label="LBL_EOM", desc="DESC_EOM", menu="MENU_VOLUME_BASED", helpLink="http://www.motivewave.com/studies/ease_of_movement.htm", requiresVolume=true, signals=true, overlay=false, studyOverlay=true)
public class EaseOfMovement
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 14, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_EOM", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 0.01, 0.0, 999.001, 0.001, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -99.001, 99.001, 0.001, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), -0.01, -999.001, 0.0, 0.001, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor3});
        SettingGroup settingGroup5 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 14, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"method", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)EaseOfMovement$Values.EM, this.get("LBL_EMO", new Object[0]), new String[]{"method", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)EaseOfMovement$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)EaseOfMovement$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declarePath((Object)EaseOfMovement$Values.EM, "line");
        runtimeDescriptor.declareIndicator((Object)EaseOfMovement$Values.EM, "ind");
        runtimeDescriptor.declareSignal((Object)EaseOfMovement$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)EaseOfMovement$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{EaseOfMovement$Values.EM});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 + 2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.0;
        double d3 = dataSeries.getVolume(n2);
        d3 /= 1000000.0;
        double d4 = dataSeries.getHigh(n2);
        double d5 = dataSeries.getLow(n2);
        double d6 = dataSeries.getHigh(n2 - 1);
        double d7 = dataSeries.getLow(n2 - 1);
        double d8 = (d4 + d5) / 2.0;
        double d9 = (d6 + d7) / 2.0;
        double d10 = d8 - d9;
        double d11 = d3 / (d4 - d5);
        d2 = d11 == 0.0 ? 0.0 : d10 / d11;
        dataSeries.setDouble(n2, (Object)EaseOfMovement$Values.ROUGH_EM, Double.valueOf(d2));
        if (n2 < n3 + 1) {
            return;
        }
        Double d12 = dataSeries.ma(mAMethod, n2, n3, (Object)EaseOfMovement$Values.ROUGH_EM);
        if (d12 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)EaseOfMovement$Values.EM, d12);
        if (n2 < n3 + 2) {
            return;
        }
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d13 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d14 = guideInfo2.getValue();
        double d15 = dataSeries.getDouble(n2 - 1, (Object)EaseOfMovement$Values.EM, 0.0);
        boolean bl2 = d12 > d13 && d15 > d12 && d12 > this.a;
        boolean bl3 = d12 < d14 && d15 < d12 && d12 < this.b;
        dataSeries.setBoolean(n2, (Object)EaseOfMovement$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)EaseOfMovement$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d12;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d12.doubleValue());
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_EASE_OF_MOVEMENT_HIGH_EM", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d12, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)EaseOfMovement$Signals.SELL, string, (Object)d4);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d12;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d12.doubleValue());
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_EASE_OF_MOVEMENT_LOW_EM", new Object[]{Util.round((double)d5, (int)2), Util.round((double)d12, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)EaseOfMovement$Signals.BUY, string, (Object)d5);
        }
        dataSeries.setComplete(n2);
    }
}

