/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general3;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.X11Colors;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.Plot;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general3.DMIStochastic$Values;

@StudyHeader(namespace="com.motivewave", id="DMI_STOCHASTIC", rb="com.motivewave.platform.study.nls.strings2", name="NAME_DMI_STOCHASTIC", desc="DESC_DMI_STOCH", label="LBL_DMIST", helpLink="http://www.motivewave.com/studies/dmi_stochastic.htm", overlay=false, studyOverlay=true)
public class DMIStochastic
extends Study {
    static final String a = "Period5";
    static final String b = "dmiOscPath";
    static final String c = "dmiOscInd";
    static final String d = "dmiStochPath";
    static final String e = "dmiStochInd";
    static final String f = "maPath";
    static final String g = "maInd";
    static final String h = "dmiStochTopG";
    static final String i = "dmiStochMidG";
    static final String j = "dmiStochBottG";
    static final String k = "upColor";
    static final String l = "downColor";
    static final String m = "dmiStochPlot";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_SETTINGS", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup("");
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("DMI_PERIOD", new Object[0]), 10, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("FAST_K_PERIOD", new Object[0]), 10, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("SLOW_K_PERIOD", new Object[0]), 3, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period4", this.get("SMOOTH_PERIOD", new Object[0]), 3, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("STOCHASTIC_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("MA_PERIOD", new Object[0]), 50, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method2", this.get("MA_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup2 = settingTab.addGroup("");
        PathDescriptor pathDescriptor = new PathDescriptor("bars", this.get("DMI_OSCILLATOR_PATH", new Object[0]), defaults.getBlue(), 1.0f, null, true, true, true);
        pathDescriptor.setShowAsBars(true);
        pathDescriptor.setSupportsShowAsBars(true);
        pathDescriptor.setColor2(defaults.getRed());
        pathDescriptor.setColorPolicy(Enums.ColorPolicy.POSITIVE_NEGATIVE);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(c, this.get("DMI_OSCILLATOR_INDICATOR", new Object[0]), defaults.getBlue(), X11Colors.WHITE, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(d, this.get("DMI_STOCHASTIC_PATH", new Object[0]), defaults.getBlue(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(e, this.get("DMI_STOCHASTIC_INDICATOR", new Object[0]), defaults.getBlue(), X11Colors.WHITE, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(f, this.get("MA_PATH", new Object[0]), defaults.getBlue(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(g, this.get("MA_INDICATOR", new Object[0]), defaults.getBlue(), X11Colors.WHITE, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("GUIDES", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("DMI_OSCILLATOR_GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 20.0, 0.0, 999.0, 1.0, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -999.0, 999.0, 1.0, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), -20.0, -999.0, 0.0, 1.0, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("DMI_STOCHASTIC_GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor4 = new GuideDescriptor(h, this.get("TOP_GUIDE", new Object[0]), 90.0, 0.0, 999.1, 0.1, true);
        guideDescriptor4.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor4});
        GuideDescriptor guideDescriptor5 = new GuideDescriptor(i, this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor5.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor5});
        GuideDescriptor guideDescriptor6 = new GuideDescriptor(j, this.get("BOTTOM_GUIDE", new Object[0]), 10.0, 0.0, 999.1, 0.1, true);
        guideDescriptor6.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor6});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("DMI_PERIOD", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("DMI_STOCH_FAST_K_PERIOD", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period3", this.get("DMI_STOCH_SLOW_K_PERIOD", new Object[0]), 3, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period4", this.get("DMI_STOCH_SMOOTH_PERIOD", new Object[0]), 3, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(a, this.get("MA_PERIOD", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"method2", b, d, f});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DMIStochastic$Values.DMI_OSC, this.get("DMI_OSC", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DMIStochastic$Values.DMI_STOCH, this.get("DMI_STOCH", new Object[0]), new String[]{"period2", "period3", "period4", "method"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DMIStochastic$Values.MA, this.get("MA", new Object[0]), new String[]{a, "method2"}));
        runtimeDescriptor.getPricePlot().setLabelSettings(new String[]{"input", a});
        runtimeDescriptor.getPricePlot().setLabelPrefix(this.get("MA", new Object[0]));
        runtimeDescriptor.getPricePlot().declarePath((Object)DMIStochastic$Values.MA, f);
        runtimeDescriptor.getPricePlot().declareIndicator((Object)DMIStochastic$Values.MA, g);
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.setLabelPrefix(this.get("DMI_OSC", new Object[0]));
        runtimeDescriptor.setTabName(this.get("DMI_OSC", new Object[0]));
        runtimeDescriptor.declarePath((Object)DMIStochastic$Values.DMI_OSC, "bars");
        runtimeDescriptor.declareIndicator((Object)DMIStochastic$Values.DMI_OSC, c);
        runtimeDescriptor.getDefaultPlot().declareGuide("topGuide");
        runtimeDescriptor.getDefaultPlot().declareGuide("middleGuide");
        runtimeDescriptor.getDefaultPlot().declareGuide("bottomGuide");
        runtimeDescriptor.setRangeKeys(new Object[]{DMIStochastic$Values.DMI_OSC});
        Plot plot = new Plot();
        runtimeDescriptor.addPlot(m, plot);
        plot.setLabelSettings(new String[]{"input", "period2", "period3", "period4"});
        plot.setLabelPrefix(this.get("DMI_STOCH", new Object[0]));
        plot.setTabName(this.get("DMI_STOCH", new Object[0]));
        plot.declarePath((Object)DMIStochastic$Values.DMI_STOCH, d);
        plot.declareIndicator((Object)DMIStochastic$Values.DMI_STOCH, e);
        plot.declareGuide(h);
        plot.declareGuide(i);
        plot.declareGuide(j);
        plot.setRangeKeys(new Object[]{DMIStochastic$Values.DMI_STOCH});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        int n5 = this.getSettings().getInteger("period4");
        int n6 = this.getSettings().getInteger(a);
        int n7 = Math.max(Math.max(Math.max(Math.max(n2, n3), n4), n5), n6);
        this.setMinBars(n7);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        int n6 = this.getSettings().getInteger("period4");
        int n7 = this.getSettings().getInteger(a);
        int n8 = Math.max(Math.max(Math.max(Math.max(n3, n4), n5), n6), n7);
        if (n2 < n8) {
            return;
        }
        Object object = this.getSettings().getInput("input");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        Enums.MAMethod mAMethod2 = this.getSettings().getMAMethod("method2");
        DataSeries dataSeries = dataContext.getDataSeries();
        Float f2 = dataSeries.getPositiveDM(n2);
        Float f3 = dataSeries.getNegativeDM(n2);
        Float f4 = dataSeries.getTrueRange(n2);
        if (f2 == null || f3 == null || f4 == null) {
            return;
        }
        dataSeries.setFloat(n2, (Object)DMIStochastic$Values.PDM, f2);
        dataSeries.setFloat(n2, (Object)DMIStochastic$Values.NDM, f3);
        dataSeries.setFloat(n2, (Object)DMIStochastic$Values.TR, f4);
        Double d2 = dataSeries.smma(n2, n3, (Object)DMIStochastic$Values.PDM);
        Double d3 = dataSeries.smma(n2, n3, (Object)DMIStochastic$Values.NDM);
        Double d4 = dataSeries.smma(n2, n3, (Object)DMIStochastic$Values.TR);
        if (d2 == null || d3 == null || d4 == null) {
            return;
        }
        double d5 = d2 / d4 * 100.0;
        double d6 = d3 / d4 * 100.0;
        double d7 = d5 - d6;
        dataSeries.setDouble(n2, (Object)DMIStochastic$Values.DMI_OSC, Double.valueOf(d7));
        if (n2 < n8 + n4) {
            return;
        }
        double d8 = dataSeries.lowest(n2, n4, (Object)DMIStochastic$Values.DMI_OSC);
        double d9 = dataSeries.highest(n2, n4, (Object)DMIStochastic$Values.DMI_OSC);
        double d10 = (d7 - d8) / (d9 - d8) * 100.0;
        dataSeries.setDouble(n2, (Object)DMIStochastic$Values.FAST_K, Double.valueOf(d10));
        if (n2 < n8 + n4 + n5) {
            return;
        }
        Double d11 = dataSeries.ma(mAMethod, n2, n5, (Object)DMIStochastic$Values.FAST_K);
        if (d11 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)DMIStochastic$Values.SLOW_K, d11);
        if (n2 < n8 + n4 + n5) {
            return;
        }
        Double d12 = dataSeries.ma(mAMethod, n2, n6, (Object)DMIStochastic$Values.SLOW_K);
        if (d12 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)DMIStochastic$Values.DMI_STOCH, d12);
        Double d13 = dataSeries.ma(mAMethod2, n2, n7, object);
        if (d13 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)DMIStochastic$Values.MA, d13);
        dataSeries.setComplete(n2);
    }
}

