/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general3;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general3.ABillWAc$Signals;
import com.motivewave.platform.study.general3.ABillWAc$Values;
import java.awt.Color;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", rb="com.motivewave.platform.study.nls.strings2", id="ID_ACC_DEC_OSCILLATOR", name="NAME_ACCELERATOR_DECELERATOR_OSCILLATOR", desc="DESC_ABW_AC", label="LBL_BWAC", menu="MENU_BILL_WILLIAMS", helpLink="http://www.motivewave.com/studies/accelerator_decelerator_oscillator.htm", signals=true, overlay=false, studyOverlay=true)
public class ABillWAc
extends Study {
    static final String a = "Period1";
    static final String b = "Period2";
    static final String c = "Period3";
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("PERIOD1", new Object[0]), 5, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b, this.get("PERIOD2", new Object[0]), 34, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(c, this.get("PERIOD3", new Object[0]), 5, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 1.5, 0.0, 100.001, 0.001, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -10.001, 10.001, 0.001, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), -1.5, -100.001, 0.0, 0.001, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(a, this.get("PERIOD1", new Object[0]), 5, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(b, this.get("PERIOD2", new Object[0]), 34, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(c, this.get("PERIOD3", new Object[0]), 5, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"upColor", "downColor"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", a, b, c});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ABillWAc$Values.AC, this.get("ABWL1", new Object[0]), new String[]{"input", "method", a, b, c}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ABillWAc$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ABillWAc$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)ABillWAc$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)ABillWAc$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declareBars((Object)ABillWAc$Values.AC);
        runtimeDescriptor.declareIndicator((Object)ABillWAc$Values.AC, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{ABillWAc$Values.AC});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger(a);
        int n3 = this.getSettings().getInteger(b);
        int n4 = this.getSettings().getInteger(c);
        this.setMinBars(Math.max(n2, n3) + n4 + 1);
    }

    public void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger(a);
        int n4 = this.getSettings().getInteger(b);
        int n5 = this.getSettings().getInteger(c);
        int n6 = Math.max(n3, n4);
        if (n2 < n6) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.MIDPOINT);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        Double d2 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d2 == null) {
            return;
        }
        Double d3 = dataSeries.ma(mAMethod, n2, n4, object);
        if (d3 == null) {
            return;
        }
        Double d4 = d2 - d3;
        dataSeries.setDouble(n2, (Object)ABillWAc$Values.AO, d4);
        if (n2 < n6 + n5) {
            return;
        }
        Double d5 = dataSeries.ma(mAMethod, n2, n5, (Object)ABillWAc$Values.AO);
        if (d5 == null) {
            return;
        }
        d5 = d4 - d5;
        dataSeries.setDouble(n2, (Object)ABillWAc$Values.AC, d5);
        if (n2 < n6 + n5 + 1) {
            return;
        }
        double d6 = dataSeries.getDouble(n2 - 1, (Object)ABillWAc$Values.AC, 0.0);
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d7 = guideInfo.getValue();
        Color color = this.getSettings().getColor("upColor");
        Color color2 = this.getSettings().getColor("downColor");
        if (d5 > d6) {
            dataSeries.setBarColor(n2, (Object)ABillWAc$Values.AC, color);
        } else {
            dataSeries.setBarColor(n2, (Object)ABillWAc$Values.AC, color2);
        }
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d8 = guideInfo2.getValue();
        double d9 = dataSeries.getLow(n2);
        double d10 = dataSeries.getHigh(n2);
        boolean bl2 = d5 > d7 && d6 > d5 && d5 > this.a;
        boolean bl3 = d5 < d8 && d6 < d5 && d5 < this.b;
        dataSeries.setBoolean(n2, (Object)ABillWAc$Signals.BUY, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)ABillWAc$Signals.SELL, Boolean.valueOf(bl2));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d5;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d5.doubleValue());
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_HIGH_BWAC", new Object[]{Util.round((double)d10, (int)2), Util.round((double)d5, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)ABillWAc$Signals.SELL, string, (Object)d10);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d5;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d5.doubleValue());
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_LOW_BWAC", new Object[]{Util.round((double)d9, (int)2), Util.round((double)d5, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)ABillWAc$Signals.BUY, string, (Object)d9);
        }
        dataSeries.setComplete(n2);
    }
}

