/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.UpsidePotentialRatio$Values;

@StudyHeader(namespace="com.motivewave", id="ID_UPSIDE", rb="com.motivewave.platform.study.nls.strings2", label="LBL_UPSIDE", name="NAME_UPSIDE_POTENTIAL_RATIO", desc="DESC_UPSIDE", helpLink="http://www.motivewave.com/studies/upside_potential_ratio.htm", signals=false, overlay=false, studyOverlay=true)
public class UpsidePotentialRatio
extends Study {
    static final String a = "Mar";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 30, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("MINIUM_RETURN", new Object[0]), 5.0, 0.0, 999.01, 0.01)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_UPSIDE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -9.01, 9.01, 0.01, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 30, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a, "line", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)UpsidePotentialRatio$Values.UPSIDE, this.get("LBL_UPSIDE", new Object[0]), new String[]{"input", "period", a}));
        runtimeDescriptor.declarePath((Object)UpsidePotentialRatio$Values.UPSIDE, "line");
        runtimeDescriptor.declareIndicator((Object)UpsidePotentialRatio$Values.UPSIDE, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{UpsidePotentialRatio$Values.UPSIDE});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 * 2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        double d2 = this.getSettings().getDouble(a);
        d2 /= 100.0;
        DataSeries dataSeries = dataContext.getDataSeries();
        int n4 = 0;
        BarSize barSize = dataSeries.getBarSize();
        if (barSize.getType() != Enums.BarSizeType.LINEAR) {
            return;
        }
        n4 = barSize.getIntervalMinutes();
        double d3 = 518400.0;
        double d4 = d3 / (double)n4;
        double d5 = Math.pow(1.0 + d2, (double)n3 / d4) - 1.0;
        double d6 = dataSeries.getDouble(n2, object, 0.0);
        double d7 = dataSeries.getDouble(n2 - n3, object, 0.0);
        double d8 = d6 / d7 - 1.0;
        dataSeries.setDouble(n2, (Object)UpsidePotentialRatio$Values.RET, Double.valueOf(d8));
        if (n2 < n3 * 2) {
            return;
        }
        Double d9 = this.a(dataSeries, n2, n3, d5, (Object)UpsidePotentialRatio$Values.RET);
        dataSeries.setDouble(n2, (Object)UpsidePotentialRatio$Values.UPSIDE, d9);
        dataSeries.setComplete(n2);
    }

    protected Double a(DataSeries dataSeries, int n2, int n3, double d2, Object object) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i2 = n2 - n3 + 1; i2 <= n2; ++i2) {
            d3 = dataSeries.getDouble(i2, object, 0.0);
            if (d3 > d2) {
                d4 += (d3 - d2) * (1.0 / (double)n3);
            }
            if (!(d3 < d2)) continue;
            d5 += Math.pow(d3 - d2, 2.0) * (1.0 / (double)n3);
        }
        if (d5 > 0.0) {
            return d4 / Math.sqrt(d5);
        }
        return null;
    }
}

