/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.BarSizeDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.SmartMoneyIndex$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_SMI", rb="com.motivewave.platform.study.nls.strings2", label="LBL_SMI", menu="MENU_GENERAL", name="NAME_SMART_MONEY_INDEX", desc="DESC_SMI", signals=false, overlay=false, studyOverlay=true)
public class SmartMoneyIndex
extends Study {
    static final String a = "bsHalfHr";
    static final String b = "bsHr";
    boolean a = true;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingsDescriptor.addInvisibleSetting((SettingDescriptor)new BarSizeDescriptor(a, "HALF_HOURLY", BarSize.getBarSize((Enums.BarSizeType)Enums.BarSizeType.LINEAR, (int)30)));
        settingsDescriptor.addInvisibleSetting((SettingDescriptor)new BarSizeDescriptor(b, "HOURLY", BarSize.getBarSize((Enums.BarSizeType)Enums.BarSizeType.LINEAR, (int)60)));
        settingsDescriptor.addQuickSettings(new String[]{"line", "ind"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{a, b});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SmartMoneyIndex$Values.SMI, this.get("LBL_SMI", new Object[0]), new String[]{a, b}));
        runtimeDescriptor.declarePath((Object)SmartMoneyIndex$Values.SMI, "line");
        runtimeDescriptor.declareIndicator((Object)SmartMoneyIndex$Values.SMI, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{SmartMoneyIndex$Values.SMI});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        BarSize barSize = dataSeries.getBarSize();
        int n3 = barSize.getIntervalMinutes();
        if (n3 != 1440) {
            if (this.a) {
                this.info("Set Bar Size to 1 Day");
                this.a = false;
            }
            return;
        }
        BarSize barSize2 = this.getSettings().getBarSize(a);
        DataSeries dataSeries2 = dataContext.getDataSeries(barSize2);
        BarSize barSize3 = this.getSettings().getBarSize(b);
        DataSeries dataSeries3 = dataContext.getDataSeries(barSize3);
        double d2 = dataSeries.getOpen(n2);
        double d3 = dataSeries.getClose(n2);
        long l2 = dataSeries.getStartTime(n2);
        int n4 = dataSeries2.findIndex(l2);
        double d4 = dataSeries2.getClose(n4);
        double d5 = dataSeries.getDouble(n2 - 1, (Object)SmartMoneyIndex$Values.SMI, d2);
        long l3 = dataSeries.getStartTime(n2 + 1);
        int n5 = dataSeries3.findIndex(l3);
        double d6 = dataSeries3.getOpen(n5 - 1);
        double d7 = d5 - (d4 - d2) + (d3 - d6);
        dataSeries.setDouble(n2, (Object)SmartMoneyIndex$Values.SMI, Double.valueOf(d7));
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

