/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.SentimentZoneOscillator$Signals;
import com.motivewave.platform.study.general2.SentimentZoneOscillator$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_SENT_ZONE_OSC", rb="com.motivewave.platform.study.nls.strings2", label="LBL_STZOSC", name="NAME_SENTIMENT_ZONE_OSCILLATOR", desc="DESC_STZOSC", helpLink="http://www.motivewave.com/studies/sentiment_zone_oscillator.htm", signals=true, overlay=false, studyOverlay=true)
public class SentimentZoneOscillator
extends Study {
    static final String a = "Ind3";
    static final String b = "Factor";
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.TEMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 14, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LONG_PERIOD", new Object[0]), 30, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("%FACTOR", new Object[0]), 95.0, 0.0, 100.01, 0.01)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_STZOSC", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        PathDescriptor pathDescriptor = new PathDescriptor("line2", this.get("OVER_BOUGHT", new Object[0]), defaults.getBlue(), Enums.PointType.DOT, Enums.Size.SMALL, true, true, false);
        pathDescriptor.setSupportsMaxPoints(true);
        pathDescriptor.setSupportsColorPolicy(false);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        pathDescriptor = new PathDescriptor("line3", this.get("OVER_SOLD", new Object[0]), defaults.getGreen(), Enums.PointType.DOT, Enums.Size.SMALL, true, true, false);
        pathDescriptor.setSupportsMaxPoints(true);
        pathDescriptor.setSupportsColorPolicy(false);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_STZOSC", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("OVER_BOUGHT", new Object[0]), defaults.getBlue(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(a, this.get("OVER_SOLD", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 7.0, 0.0, 99.0, 1.0, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -99.0, 99.0, 1.0, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), -7.0, 0.0, -99.0, 1.0, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingGroup2 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 14, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("LONG_PERIOD", new Object[0]), 30, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{b, "line", "line2", "line3"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SentimentZoneOscillator$Values.SZO, this.get("LBL_STZOSC", new Object[0]), new String[]{"input", "method", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SentimentZoneOscillator$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SentimentZoneOscillator$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)SentimentZoneOscillator$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)SentimentZoneOscillator$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)SentimentZoneOscillator$Values.SZO, "line");
        runtimeDescriptor.declarePath((Object)SentimentZoneOscillator$Values.OB, "line2");
        runtimeDescriptor.declarePath((Object)SentimentZoneOscillator$Values.OS, "line3");
        runtimeDescriptor.declareIndicator((Object)SentimentZoneOscillator$Values.SZO, "ind");
        runtimeDescriptor.declareIndicator((Object)SentimentZoneOscillator$Values.OB, "ind2");
        runtimeDescriptor.declareIndicator((Object)SentimentZoneOscillator$Values.OS, a);
        runtimeDescriptor.setRangeKeys(new Object[]{SentimentZoneOscillator$Values.SZO, SentimentZoneOscillator$Values.OB, SentimentZoneOscillator$Values.OS});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        double d2;
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        if (n2 < 1) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        double d3 = this.getSettings().getDouble(b);
        d3 /= 100.0;
        DataSeries dataSeries = dataContext.getDataSeries();
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = dataSeries.getDouble(n2, object, 0.0);
        d4 = d11 > (d2 = dataSeries.getDouble(n2 - 1, object, 0.0)) ? 1.0 : -1.0;
        dataSeries.setDouble(n2, (Object)SentimentZoneOscillator$Values.R, Double.valueOf(d4));
        if (n2 < n3 * 3 + 1) {
            return;
        }
        Double d12 = dataSeries.ma(mAMethod, n2, n3, (Object)SentimentZoneOscillator$Values.R);
        if (d12 == null) {
            return;
        }
        d5 = 100.0 * d12 / (double)n3;
        dataSeries.setDouble(n2, (Object)SentimentZoneOscillator$Values.SZO, Double.valueOf(d5));
        if (n2 < n3 * 3 + n4 + 1) {
            return;
        }
        d7 = dataSeries.highest(n2, n4, (Object)SentimentZoneOscillator$Values.SZO);
        d6 = dataSeries.lowest(n2, n4, (Object)SentimentZoneOscillator$Values.SZO);
        d8 = d7 - d6;
        d9 = d6 + d8 * d3;
        d10 = d7 - d8 * d3;
        dataSeries.setDouble(n2, (Object)SentimentZoneOscillator$Values.OB, Double.valueOf(d9));
        dataSeries.setDouble(n2, (Object)SentimentZoneOscillator$Values.OS, Double.valueOf(d10));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d13 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d14 = guideInfo2.getValue();
        boolean bl2 = d5 > d9 || d5 > d13;
        boolean bl3 = d5 < d10 || d5 < d14;
        dataSeries.setBoolean(n2, (Object)SentimentZoneOscillator$Signals.BUY, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)SentimentZoneOscillator$Signals.SELL, Boolean.valueOf(bl2));
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d5);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_SZO_OB", new Object[]{Util.round((double)d11, (int)2), Util.round((double)d5, (int)2), Util.round((double)d9, (int)2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)SentimentZoneOscillator$Signals.SELL, string, (Object)d11);
        }
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d5);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_SZO_OS", new Object[]{Util.round((double)d11, (int)2), Util.round((double)d5, (int)2), Util.round((double)d10, (int)2)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)SentimentZoneOscillator$Signals.BUY, string, (Object)d11);
        }
        dataSeries.setComplete(n2);
    }
}

