/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.HilbertTransform$Values;

@StudyHeader(namespace="com.motivewave", id="ID_HILBERT_TRANSFORM", rb="com.motivewave.platform.study.nls.strings2", label="LBL_HILBT", name="NAME_HILBERT_TRANSFORM_INDICATOR", desc="DESC_HILBT", menu="MENU_JOHN_EHLERS", helpLink="http://www.motivewave.com/studies/hilbert_transform_indicator.htm", signals=false, overlay=false, studyOverlay=true)
public class HilbertTransform
extends Study {
    static final double a = 0.635;
    static final double b = 0.338;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 7, 7, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("INPHASE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("QUADRATURE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("INPHASE", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("QUADRATURE", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -999.01, 999.01, 0.01, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup2 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 7, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "line2", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)HilbertTransform$Values.INPHASE, this.get("INPHASE", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.declarePath((Object)HilbertTransform$Values.INPHASE, "line");
        runtimeDescriptor.declarePath((Object)HilbertTransform$Values.QUAD, "line2");
        runtimeDescriptor.declareIndicator((Object)HilbertTransform$Values.INPHASE, "ind");
        runtimeDescriptor.declareIndicator((Object)HilbertTransform$Values.QUAD, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{HilbertTransform$Values.INPHASE, HilbertTransform$Values.QUAD});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 + 4);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.MIDPOINT);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = dataSeries.getDouble(n2 - n3, object, 0.0);
        double d4 = d2 - d3;
        dataSeries.setDouble(n2, (Object)HilbertTransform$Values.V1, Double.valueOf(d4));
        if (n2 < n3 + 4) {
            return;
        }
        double d5 = dataSeries.getDouble(n2 - 2, (Object)HilbertTransform$Values.V1, 0.0);
        double d6 = dataSeries.getDouble(n2 - 4, (Object)HilbertTransform$Values.V1, 0.0);
        double d7 = dataSeries.getDouble(n2 - 3, (Object)HilbertTransform$Values.INPHASE, 0.0);
        double d8 = dataSeries.getDouble(n2 - 2, (Object)HilbertTransform$Values.QUAD, 0.0);
        double d9 = 1.25 * (d6 - 0.635 * d5 + 0.635 * d7);
        double d10 = d5 - 0.338 * d4 + 0.338 * d8;
        dataSeries.setDouble(n2, (Object)HilbertTransform$Values.INPHASE, Double.valueOf(d9));
        dataSeries.setDouble(n2, (Object)HilbertTransform$Values.QUAD, Double.valueOf(d10));
        dataSeries.setComplete(n2);
    }
}

