/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.HalloweenInd$Signals;
import com.motivewave.platform.study.general2.HalloweenInd$Values;
import java.util.GregorianCalendar;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_HALLOWEEN", rb="com.motivewave.platform.study.nls.strings2", label="LBL_HLWNI", name="NAME_HALLOWEEN_INDICATOR", desc="DESC_HLWNI", helpLink="http://www.motivewave.com/studies/halloween_indicator.htm", signals=true, overlay=true, studyOverlay=true)
public class HalloweenInd
extends Study {
    static final String a = "HighLow";
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 50, 1, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("INDICATOR", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 50, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)HalloweenInd$Values.HLWNI, this.get("LBL_HLWNI", new Object[0]), new String[]{"input", "method", "period", "period2", "period3"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)HalloweenInd$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)HalloweenInd$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)HalloweenInd$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)HalloweenInd$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)HalloweenInd$Values.HLWNI, "line");
        runtimeDescriptor.declareIndicator((Object)HalloweenInd$Values.HLWNI, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{HalloweenInd$Values.HLWNI});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        Double d3 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d3 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)HalloweenInd$Values.HLWNI, d3);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        long l2 = dataSeries.getStartTime(n2);
        gregorianCalendar.setTimeInMillis(l2);
        int n4 = gregorianCalendar.get(2);
        boolean bl2 = n4 == 4;
        boolean bl3 = d2 < d3 && n4 == 9;
        dataSeries.setBoolean(n2, (Object)HalloweenInd$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)HalloweenInd$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d3.doubleValue());
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_HLWNI", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d3, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)HalloweenInd$Signals.SELL, string, (Object)d2);
        }
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d3.doubleValue());
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_HLWNI", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d3, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)HalloweenInd$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

