/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.ElderRayBear$Signals;
import com.motivewave.platform.study.general2.ElderRayBear$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ID_ERBEAR", rb="com.motivewave.platform.study.nls.strings2", label="LBL_ERBEAR", name="NAME_ELDER_RAY_BEAR_POWER", desc="DESC_ERBEAR", menu="MENU_ALEXANDER_ELDER", helpLink="http://www.motivewave.com/studies/elder_ray_bear_power.htm", signals=false, overlay=false, studyOverlay=true)
public class ElderRayBear
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 13, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -9.1, 9.1, 0.01, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 13, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"upColor", "downColor"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ElderRayBear$Values.BEAR, this.get("LBL_ERBEAR", new Object[0]), new String[]{"input", "method", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ElderRayBear$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ElderRayBear$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)ElderRayBear$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)ElderRayBear$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declareBars((Object)ElderRayBear$Values.BEAR);
        runtimeDescriptor.declareIndicator((Object)ElderRayBear$Values.BEAR, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{ElderRayBear$Values.BEAR});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, (Object)Enums.BarInput.LOW, 0.0);
        double d3 = dataSeries.getDouble(n2, (Object)Enums.BarInput.HIGH, 0.0);
        Double d4 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d4 == null) {
            return;
        }
        double d5 = d2 - d4;
        double d6 = d3 - d4;
        dataSeries.setDouble(n2, (Object)ElderRayBear$Values.BEAR, Double.valueOf(d5));
        dataSeries.setDouble(n2, (Object)ElderRayBear$Values.MA, d4);
        dataSeries.setDouble(n2, (Object)ElderRayBear$Values.BULL, Double.valueOf(d6));
        GuideInfo guideInfo = this.getSettings().getGuide("middleGuide");
        double d7 = guideInfo.getValue();
        Color color = this.getSettings().getColor("upColor");
        Color color2 = this.getSettings().getColor("downColor");
        if (d5 > d7) {
            dataSeries.setBarColor(n2, (Object)ElderRayBear$Values.BEAR, color);
        } else {
            dataSeries.setBarColor(n2, (Object)ElderRayBear$Values.BEAR, color2);
        }
        double d8 = dataSeries.getDouble(n2 - 1, (Object)ElderRayBear$Values.BEAR, d5);
        double d9 = dataSeries.getDouble(n2 - 1, (Object)ElderRayBear$Values.MA, d4.doubleValue());
        double d10 = dataSeries.getDouble(n2 - 1, (Object)ElderRayBear$Values.BULL, d6);
        boolean bl2 = d5 < d7 && d5 > d8 && d4 > d9 && d5 < this.b;
        boolean bl3 = d6 > d7 && d6 < d10 && d4 < d9 && d6 > this.a;
        dataSeries.setBoolean(n2, (Object)ElderRayBear$Signals.SELL, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)ElderRayBear$Signals.BUY, Boolean.valueOf(bl2));
        if (bl3) {
            this.b = Double.MAX_VALUE;
        }
        if (bl2) {
            this.b = d5;
            Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d5);
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("BUY_LOW_BEAR", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d5, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)ElderRayBear$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

