/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general2;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general2.ElderForceIndex$Signals;
import com.motivewave.platform.study.general2.ElderForceIndex$Values;
import java.awt.Color;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_EFORCE", rb="com.motivewave.platform.study.nls.strings2", label="LBL_EFORCE", name="NAME_ELDERS_FORCE_INDEX", desc="DESC_EFORCE", menu="MENU_ALEXANDER_ELDER", helpLink="http://www.motivewave.com/studies/elders_force_index.htm", signals=true, overlay=false, studyOverlay=true)
public class ElderForceIndex
extends Study {
    static final String a = "BuyColor";
    static final String b = "SellColor";
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD1", new Object[0]), 2, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERIOD2", new Object[0]), 13, 1, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getTopFillColor())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getBottomFillColor())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(a, this.get("BUY_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(b, this.get("SELL_COLOR", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("MA_PATH", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("FORCE", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("MA", new Object[0]), defaults.getRed(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -9.1, 9.1, 0.01, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD1", new Object[0]), 2, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("PERIOD2", new Object[0]), 13, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line2", "upColor", "downColor"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ElderForceIndex$Values.MA, this.get("LBL_EREMA", new Object[0]), new String[]{"input", "method", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ElderForceIndex$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ElderForceIndex$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)ElderForceIndex$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)ElderForceIndex$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declareBars((Object)ElderForceIndex$Values.FORCE);
        runtimeDescriptor.declarePath((Object)ElderForceIndex$Values.MA, "line2");
        runtimeDescriptor.declareIndicator((Object)ElderForceIndex$Values.FORCE, "ind");
        runtimeDescriptor.declareIndicator((Object)ElderForceIndex$Values.MA, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{ElderForceIndex$Values.FORCE, ElderForceIndex$Values.MA});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(Math.max(n2, n3) + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        if (n2 < 1) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = dataSeries.getDouble(n2 - 1, object, 0.0);
        long l2 = dataSeries.getVolume(n2);
        double d4 = (double)l2 * (d2 - d3);
        dataSeries.setDouble(n2, (Object)ElderForceIndex$Values.RAW_FORCE, Double.valueOf(d4));
        if (n2 < Math.max(n3, n4) + 1) {
            return;
        }
        Double d5 = dataSeries.ma(mAMethod, n2, n3, (Object)ElderForceIndex$Values.RAW_FORCE);
        Double d6 = dataSeries.ma(mAMethod, n2, n4, (Object)ElderForceIndex$Values.RAW_FORCE);
        dataSeries.setDouble(n2, (Object)ElderForceIndex$Values.FORCE, d5);
        dataSeries.setDouble(n2, (Object)ElderForceIndex$Values.MA, d6);
        GuideInfo guideInfo = this.getSettings().getGuide("middleGuide");
        double d7 = guideInfo.getValue();
        dataSeries.setComplete(n2);
        double d8 = dataSeries.getDouble(n2 - 1, (Object)ElderForceIndex$Values.MA, d6.doubleValue());
        boolean bl2 = d5 > d7 && d6 < d8 && d2 > this.a;
        boolean bl3 = d5 < d7 && d6 > d8 && d2 < this.b;
        dataSeries.setBoolean(n2, (Object)ElderForceIndex$Signals.BUY, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)ElderForceIndex$Signals.SELL, Boolean.valueOf(bl2));
        Color color = this.getSettings().getColor("upColor");
        Color color2 = this.getSettings().getColor("downColor");
        Color color3 = this.getSettings().getColor(a);
        Color color4 = this.getSettings().getColor(b);
        if (d5 > d7) {
            dataSeries.setBarColor(n2, (Object)ElderForceIndex$Values.FORCE, color);
        } else {
            dataSeries.setBarColor(n2, (Object)ElderForceIndex$Values.FORCE, color2);
        }
        if (bl3) {
            dataSeries.setBarColor(n2, (Object)ElderForceIndex$Values.FORCE, color3);
        }
        if (bl2) {
            dataSeries.setBarColor(n2, (Object)ElderForceIndex$Values.FORCE, color4);
        }
        if (bl2) {
            this.a = d2;
            this.b = Double.MAX_VALUE;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d5.doubleValue());
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_FORCE", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d5, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)ElderForceIndex$Signals.SELL, string, (Object)d2);
        }
        if (bl3) {
            this.b = d2;
            this.a = Double.NEGATIVE_INFINITY;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d5.doubleValue());
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_LOW_FORCE", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d5, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)ElderForceIndex$Signals.BUY, string, (Object)d2);
        }
    }
}

