/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.BarSizeDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.Wallaby$Values;

@StudyHeader(namespace="com.motivewave", id="WALLABY", rb="com.motivewave.platform.study.nls.strings", name="TITLE_WALLABY", desc="DESC_WALLABY", menu="MENU_GENERAL", menu2="MENU_CUSTOM", overlay=false, helpLink="http://www.motivewave.com/studies/wallaby.htm")
public class Wallaby
extends Study {
    static final String a = "kPeriod";
    static final String b = "dPeriod";
    static final String c = "timeframe1";
    static final String d = "timeframe2";
    static final String e = "timeframe3";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_K_PERIOD", new Object[0]), 14, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b, this.get("LBL_D_PERIOD", new Object[0]), 3, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new BarSizeDescriptor(c, this.get("LBL_TIMEFRAME1", new Object[0]), BarSize.getBarSize((Enums.BarSizeType)Enums.BarSizeType.LINEAR, (int)15))});
        settingGroup.addRow(new SettingDescriptor[]{new BarSizeDescriptor(d, this.get("LBL_TIMEFRAME2", new Object[0]), BarSize.getBarSize((Enums.BarSizeType)Enums.BarSizeType.LINEAR, (int)30))});
        settingGroup.addRow(new SettingDescriptor[]{new BarSizeDescriptor(e, this.get("LBL_TIMEFRAME3", new Object[0]), BarSize.getBarSize((Enums.BarSizeType)Enums.BarSizeType.LINEAR, (int)60))});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "topGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "bottomGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_ADVANCED", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 80.0, 1.0, 100.0, 1.0, true)});
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("LBL_MIDDLE_GUIDE", new Object[0]), 50.0, 1.0, 100.0, 1.0, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), 20.0, 1.0, 100.0, 1.0, true)});
        settingsDescriptor.addQuickSettings(new String[]{"method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(a, this.get("LBL_K_PERIOD", new Object[0]), 14, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(b, this.get("LBL_D_PERIOD", new Object[0]), 3, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{c, d, e, "line", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"method", a, b, c, d, e});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Wallaby$Values.WALLABY, this.get("LBL_WALLABY", new Object[0]), new String[]{"method", a, b, c, d, e}));
        runtimeDescriptor.declarePath((Object)Wallaby$Values.WALLABY, "line");
        runtimeDescriptor.declareIndicator((Object)Wallaby$Values.WALLABY, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{Wallaby$Values.WALLABY});
        runtimeDescriptor.setMaxBottomValue(Integer.valueOf(10));
        runtimeDescriptor.setMinTopValue(Integer.valueOf(90));
        runtimeDescriptor.setMinTick(Double.valueOf(0.1));
    }

    protected void calculateValues(DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        DataSeries dataSeries2 = dataContext.getDataSeries(this.getSettings().getBarSize(c));
        for (int i2 = 0; i2 < dataSeries2.size(); ++i2) {
            if (dataSeries2.isComplete(i2)) continue;
            this.a(i2, dataSeries2);
        }
        DataSeries dataSeries3 = dataContext.getDataSeries(this.getSettings().getBarSize(d));
        for (int i3 = 0; i3 < dataSeries3.size(); ++i3) {
            if (dataSeries3.isComplete(i3)) continue;
            this.a(i3, dataSeries3);
        }
        DataSeries dataSeries4 = dataContext.getDataSeries(this.getSettings().getBarSize(e));
        for (int i4 = 0; i4 < dataSeries4.size(); ++i4) {
            if (dataSeries4.isComplete(i4)) continue;
            this.a(i4, dataSeries4);
        }
        BarSize barSize = dataSeries.getBarSize();
        for (int i5 = 0; i5 < dataSeries.size(); ++i5) {
            if (dataSeries.getDouble(i5, (Object)Wallaby$Values.WALLABY) != null && i5 < dataSeries.size() - 1) continue;
            Double d2 = this.a(dataSeries2, dataSeries.getStartTime(i5), dataSeries.getEndTime(i5), barSize);
            Double d3 = this.a(dataSeries3, dataSeries.getStartTime(i5), dataSeries.getEndTime(i5), barSize);
            Double d4 = this.a(dataSeries4, dataSeries.getStartTime(i5), dataSeries.getEndTime(i5), barSize);
            if (d2 == null || d3 == null || d4 == null) continue;
            dataSeries.setDouble(i5, (Object)Wallaby$Values.WALLABY, Double.valueOf((d2 + d3 + d4) / 3.0));
            dataSeries.setComplete(i5, dataSeries.isBarComplete(i5));
        }
    }

    protected void a(int n2, DataSeries dataSeries) {
        int n3 = this.getSettings().getInteger(a);
        int n4 = this.getSettings().getInteger(b);
        int n5 = 3;
        if (n2 < n3) {
            return;
        }
        dataSeries.setDouble(n2, (Object)Wallaby$Values.K, dataSeries.stochasticK(n2, n3));
        if (n2 < n3 + n4) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        Double d2 = dataSeries.ma(mAMethod, n2, n4, (Object)Wallaby$Values.K);
        dataSeries.setDouble(n2, (Object)Wallaby$Values.P_K, d2);
        if (n2 < n3 + n4 + n5) {
            return;
        }
        Double d3 = dataSeries.ma(mAMethod, n2, n5, (Object)Wallaby$Values.P_K);
        dataSeries.setDouble(n2, (Object)Wallaby$Values.P_D, d3);
        dataSeries.setComplete(n2);
    }

    protected Double a(DataSeries dataSeries, long l2, long l3, BarSize barSize) {
        int n2 = dataSeries.findIndex(l2);
        if (n2 < 0) {
            return null;
        }
        if (dataSeries.getBarSize().getIntervalMinutes() == barSize.getIntervalMinutes()) {
            Double d2 = dataSeries.getDouble(n2, (Object)Wallaby$Values.P_D);
            return d2;
        }
        if (dataSeries.getBarSize().getIntervalMinutes() > barSize.getIntervalMinutes()) {
            Double d3 = dataSeries.getDouble(n2, (Object)Wallaby$Values.P_D);
            return d3;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i2 = n2; i2 < dataSeries.size() && dataSeries.getStartTime(i2) < l3; ++i2) {
            Double d6 = dataSeries.getDouble(i2, (Object)Wallaby$Values.P_D);
            if (d6 == null) continue;
            d4 += d6.doubleValue();
            d5 += 1.0;
        }
        return d4 / d5;
    }
}

