/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.VortexIndicator$Signals;
import com.motivewave.platform.study.general.VortexIndicator$Values;

@StudyHeader(namespace="com.motivewave", id="ID_VORTEX", rb="com.motivewave.platform.study.nls.strings2", label="LBL_VORTEX", name="NAME_VORTEX_INDICATOR", desc="DESC_VORTEX", menu="MENU_OSCILLATORS", helpLink="http://www.motivewave.com/studies/vortex_indicator.htm", signals=true, overlay=false, studyOverlay=true)
public class VortexIndicator
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUT", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 21, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PLUS", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("MINUS", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("PLUS", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("MINUS", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 1.0, 0.0, 9.01, 0.01, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        SettingGroup settingGroup5 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 21, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "line2", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VortexIndicator$Values.VIPLUS, this.get("PLUS", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VortexIndicator$Values.VIMINUS, this.get("MINUS", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VortexIndicator$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)VortexIndicator$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)VortexIndicator$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)VortexIndicator$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)VortexIndicator$Values.VIPLUS, "line");
        runtimeDescriptor.declarePath((Object)VortexIndicator$Values.VIMINUS, "line2");
        runtimeDescriptor.declareIndicator((Object)VortexIndicator$Values.VIPLUS, "ind");
        runtimeDescriptor.declareIndicator((Object)VortexIndicator$Values.VIMINUS, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{VortexIndicator$Values.VIPLUS, VortexIndicator$Values.VIMINUS});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getHigh(n2);
        double d3 = dataSeries.getLow(n2);
        double d4 = dataSeries.getTrueRange(n2).floatValue();
        dataSeries.setDouble(n2, (Object)VortexIndicator$Values.TR, Double.valueOf(d4));
        double d5 = dataSeries.getLow(n2 - 1);
        double d6 = dataSeries.getHigh(n2 - 1);
        double d7 = Math.abs(d2 - d5);
        double d8 = Math.abs(d3 - d6);
        dataSeries.setDouble(n2, (Object)VortexIndicator$Values.VMPLUS, Double.valueOf(d7));
        dataSeries.setDouble(n2, (Object)VortexIndicator$Values.VMMINUS, Double.valueOf(d8));
        if (n2 < n3 + 1) {
            return;
        }
        double d9 = dataSeries.sum(n2, n3, (Object)VortexIndicator$Values.TR);
        double d10 = dataSeries.sum(n2, n3, (Object)VortexIndicator$Values.VMPLUS);
        double d11 = dataSeries.sum(n2, n3, (Object)VortexIndicator$Values.VMMINUS);
        double d12 = d10 / d9;
        double d13 = d11 / d9;
        dataSeries.setDouble(n2, (Object)VortexIndicator$Values.VIPLUS, Double.valueOf(d12));
        dataSeries.setDouble(n2, (Object)VortexIndicator$Values.VIMINUS, Double.valueOf(d13));
        boolean bl2 = this.crossedAbove(dataSeries, n2, (Object)VortexIndicator$Values.VIPLUS, (Object)VortexIndicator$Values.VIMINUS);
        boolean bl3 = this.crossedBelow(dataSeries, n2, (Object)VortexIndicator$Values.VIPLUS, (Object)VortexIndicator$Values.VIMINUS);
        dataSeries.setBoolean(n2, (Object)VortexIndicator$Signals.SELL, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)VortexIndicator$Signals.BUY, Boolean.valueOf(bl2));
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d12);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_VORTEX_HIGH_VMPLUS", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d12, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)VortexIndicator$Signals.SELL, string, (Object)d2);
        }
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d12);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_VORTEX_LOW_VMPLUS", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d12, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)VortexIndicator$Signals.BUY, string, (Object)d3);
        }
        dataSeries.setComplete(n2);
    }
}

