/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.common.h;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.UltimateOsc$Signals;
import com.motivewave.platform.study.general.UltimateOsc$Values;

@StudyHeader(namespace="com.motivewave", id="ULT_OSC", rb="com.motivewave.platform.study.nls.strings", name="TITLE_ULT_OSC", tabName="TAB_ULT_OSC", desc="DESC_ULT_OSC", menu="MENU_GENERAL", overlay=false, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/ultimate_oscillator.htm")
public class UltimateOsc
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 7, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LBL_PERIOD2", new Object[0]), 14, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("LBL_PERIOD3", new Object[0]), 28, 1, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "topGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "bottomGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_ADVANCED", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 70.0, 1.0, 100.0, 1.0, true)});
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("LBL_MIDDLE_GUIDE", new Object[0]), 50.0, 1.0, 100.0, 1.0, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup3.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), 30.0, 1.0, 100.0, 1.0, true)});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 7, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("LBL_PERIOD2", new Object[0]), 14, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period3", this.get("LBL_PERIOD3", new Object[0]), 28, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"period", "period2", "period3"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)UltimateOsc$Values.UO, this.get("VAL_ULT_OSC", new Object[0]), new String[]{"period", "period2", "period3"}));
        runtimeDescriptor.declarePath((Object)UltimateOsc$Values.UO, "line");
        runtimeDescriptor.declareIndicator((Object)UltimateOsc$Values.UO, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{UltimateOsc$Values.UO});
        runtimeDescriptor.setMaxBottomValue(Integer.valueOf(15));
        runtimeDescriptor.setMinTopValue(Integer.valueOf(85));
        runtimeDescriptor.setMinTick(Double.valueOf(0.1));
        runtimeDescriptor.declareSignal((Object)UltimateOsc$Signals.UO_TOP, this.get("LBL_UO_TOP", new Object[0]));
        runtimeDescriptor.declareSignal((Object)UltimateOsc$Signals.UO_BOTTOM, this.get("LBL_UO_BOTTOM", new Object[0]));
    }

    protected void calculate(int n2, DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        int n6 = h.c(n3, n4, n5);
        if (n2 < 1) {
            return;
        }
        double d2 = Math.min(dataSeries.getLow(n2), dataSeries.getClose(n2 - 1));
        double d3 = (double)dataSeries.getClose(n2) - d2;
        double d4 = dataSeries.getTrueRange(n2).floatValue();
        dataSeries.setDouble(n2, (Object)UltimateOsc$Values.BP, Double.valueOf(d3));
        dataSeries.setDouble(n2, (Object)UltimateOsc$Values.TR, Double.valueOf(d4));
        if (n2 <= n3) {
            return;
        }
        double d5 = dataSeries.sum(n2, n3, (Object)UltimateOsc$Values.BP);
        double d6 = dataSeries.sum(n2, n3, (Object)UltimateOsc$Values.TR);
        dataSeries.setDouble(n2, (Object)UltimateOsc$Values.DIV1, Double.valueOf(d5 / d6));
        if (n2 <= n4) {
            return;
        }
        double d7 = dataSeries.sum(n2, n4, (Object)UltimateOsc$Values.BP);
        double d8 = dataSeries.sum(n2, n4, (Object)UltimateOsc$Values.TR);
        dataSeries.setDouble(n2, (Object)UltimateOsc$Values.DIV2, Double.valueOf(d7 / d8));
        if (n2 <= n5) {
            return;
        }
        double d9 = dataSeries.sum(n2, n5, (Object)UltimateOsc$Values.BP);
        double d10 = dataSeries.sum(n2, n5, (Object)UltimateOsc$Values.TR);
        dataSeries.setDouble(n2, (Object)UltimateOsc$Values.DIV3, Double.valueOf(d9 / d10));
        if (n2 <= n6) {
            return;
        }
        Double d11 = dataSeries.getDouble(n2, (Object)UltimateOsc$Values.DIV1);
        Double d12 = dataSeries.getDouble(n2, (Object)UltimateOsc$Values.DIV2);
        Double d13 = dataSeries.getDouble(n2, (Object)UltimateOsc$Values.DIV3);
        if (d11 == null || d12 == null || d13 == null) {
            return;
        }
        double d14 = 4.0 * d11 + 2.0 * d12 + d13;
        double d15 = d14 / 7.0 * 100.0;
        dataSeries.setDouble(n2, (Object)UltimateOsc$Values.UO, Double.valueOf(d15));
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        d15 = this.round(d15);
        if (this.crossedAbove(dataSeries, n2, (Object)UltimateOsc$Values.UO, guideInfo.getValue())) {
            dataContext.signal(n2, (Object)UltimateOsc$Signals.UO_TOP, this.get("SIGNAL_UO_TOP", new Object[]{d15, guideInfo.getValue()}), (Object)d15);
        } else if (this.crossedBelow(dataSeries, n2, (Object)UltimateOsc$Values.UO, guideInfo2.getValue())) {
            dataContext.signal(n2, (Object)UltimateOsc$Signals.UO_BOTTOM, this.get("SIGNAL_UO_BOTTOM", new Object[]{d15, guideInfo2.getValue()}), (Object)d15);
        }
        dataSeries.setComplete(n2);
    }
}

