/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.TurboStochasticsSlow$Signals;
import com.motivewave.platform.study.general.TurboStochasticsSlow$Values;
import com.motivewave.platform.study.general.j;

@StudyHeader(namespace="com.motivewave", id="ID_TBSTS", rb="com.motivewave.platform.study.nls.strings2", label="LBL_TBSTS", name="NAME_TURBO_STOCHASTICS_SLOW", desc="DESC_TBSTS", helpLink="http://www.motivewave.com/studies/turbo_stochastics_slow.htm", signals=true, overlay=false, studyOverlay=true)
public class TurboStochasticsSlow
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("SLOW_K_PERIOD", new Object[0]), 20, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("SLOW_D_PERIOD", new Object[0]), 20, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("REGRESS", new Object[0]), 10, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period4", this.get("TURBO", new Object[0]), 2, -999, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("SLOW_K", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("SLOW_D", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("SLOW_K", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SLOW_D", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 70.0, 0.0, 9999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 9999.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 30.0, 0.0, 9999.1, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingGroup2 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("SLOW_K_PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("SLOW_D_PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period3", this.get("REGRESS", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period4", this.get("TURBO", new Object[0]), 2, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "line2"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", "period3", "period4"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TurboStochasticsSlow$Values.SLOWK, this.get("LBL_TBSTS", new Object[0]), new String[]{"input", "period", "period2", "period3", "period4"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TurboStochasticsSlow$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TurboStochasticsSlow$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)TurboStochasticsSlow$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)TurboStochasticsSlow$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)TurboStochasticsSlow$Values.TSSK, "line");
        runtimeDescriptor.declarePath((Object)TurboStochasticsSlow$Values.TSSD, "line2");
        runtimeDescriptor.declareIndicator((Object)TurboStochasticsSlow$Values.TSSK, "ind");
        runtimeDescriptor.declareIndicator((Object)TurboStochasticsSlow$Values.TSSD, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{TurboStochasticsSlow$Values.TSSK, TurboStochasticsSlow$Values.TSSD});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        this.setMinBars(n2 * 2 + n3 + n4);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        if (n2 < n3) {
            return;
        }
        int n5 = this.getSettings().getInteger("period3");
        int n6 = this.getSettings().getInteger("period4");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = j.d(dataSeries, n2, n3, object);
        dataSeries.setDouble(n2, (Object)TurboStochasticsSlow$Values.FK, Double.valueOf(d3));
        if (n2 < n3 * 2) {
            return;
        }
        double d4 = dataSeries.sma(n2, n3, (Object)TurboStochasticsSlow$Values.FK);
        dataSeries.setDouble(n2, (Object)TurboStochasticsSlow$Values.SLOWK, Double.valueOf(d4));
        if (n2 < n3 * 2 + n4) {
            return;
        }
        double d5 = dataSeries.sma(n2, n4, (Object)TurboStochasticsSlow$Values.SLOWK);
        dataSeries.setDouble(n2, (Object)TurboStochasticsSlow$Values.SLOWD, Double.valueOf(d5));
        if (n2 < n3 * 2 + n4 + n5) {
            return;
        }
        if (n6 < 0) {
            n6 = Math.max(n6, -n5);
        }
        if (n6 > 0) {
            n6 = Math.min(n6, n5);
        }
        double[] dArray = j.a(dataSeries, n2, n5, (Object)TurboStochasticsSlow$Values.SLOWK, n5 + n6);
        double[] dArray2 = j.a(dataSeries, n2, n5, (Object)TurboStochasticsSlow$Values.SLOWD, n5 + n6);
        dataSeries.setDouble(n2, (Object)TurboStochasticsSlow$Values.TSSK, Double.valueOf(dArray[0]));
        dataSeries.setDouble(n2, (Object)TurboStochasticsSlow$Values.TSSD, Double.valueOf(dArray2[0]));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d6 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d7 = guideInfo2.getValue();
        boolean bl2 = this.crossedBelow(dataSeries, n2, (Object)TurboStochasticsSlow$Values.TSSK, (Object)TurboStochasticsSlow$Values.TSSD) && dArray[0] > d6 && dArray[0] > this.a;
        boolean bl3 = this.crossedAbove(dataSeries, n2, (Object)TurboStochasticsSlow$Values.TSSK, (Object)TurboStochasticsSlow$Values.TSSD) && dArray[0] < d7 && dArray[0] < this.b;
        dataSeries.setBoolean(n2, (Object)TurboStochasticsSlow$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)TurboStochasticsSlow$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = dArray[0];
            coordinate = new Coordinate(dataSeries.getStartTime(n2), dArray[0]);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_TBSTS", new Object[]{Util.round((double)d2, (int)2), Util.round((double)dArray[0], (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)TurboStochasticsSlow$Signals.SELL, string, (Object)d2);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = dArray[0];
            coordinate = new Coordinate(dataSeries.getStartTime(n2), dArray[0]);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_TBSTS", new Object[]{Util.round((double)d2, (int)2), Util.round((double)dArray[0], (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)TurboStochasticsSlow$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

