/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.TRIX$Signals;
import com.motivewave.platform.study.general.TRIX$Values;

@StudyHeader(namespace="com.motivewave", id="TRIX", rb="com.motivewave.platform.study.nls.strings", name="TITLE_TRIX", desc="DESC_TRIX", menu="MENU_GENERAL", overlay=false, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/trix.htm")
public class TRIX
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_SMOOTHING_PERIOD", new Object[0]), 15, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 9, 1, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_DISPLAY", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.5f, null, true, false, true);
        pathDescriptor.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        PathDescriptor pathDescriptor2 = new PathDescriptor("signalLine", this.get("LBL_SIGNAL_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true);
        pathDescriptor2.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor2});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("signalInd", this.get("LBL_SIGNAL_IND", new Object[0]), null, null, false, false, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_SMOOTHING_PERIOD", new Object[0]), 15, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 9, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "signalLine"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TRIX$Values.TRIX, this.get("VAL_TRIX", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TRIX$Values.SIGNAL, this.get("VAL_TRIX_SIGNAL", new Object[0]), new String[]{"period2"}));
        runtimeDescriptor.declarePath((Object)TRIX$Values.TRIX, "line");
        runtimeDescriptor.declarePath((Object)TRIX$Values.SIGNAL, "signalLine");
        runtimeDescriptor.declareIndicator((Object)TRIX$Values.TRIX, "ind");
        runtimeDescriptor.declareIndicator((Object)TRIX$Values.SIGNAL, "signalInd");
        runtimeDescriptor.declareSignal((Object)TRIX$Signals.CROSS_ABOVE, this.get("LBL_CROSS_ABOVE_SIGNAL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)TRIX$Signals.CROSS_BELOW, this.get("LBL_CROSS_BELOW_SIGNAL", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{TRIX$Values.TRIX, TRIX$Values.SIGNAL});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, null));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period", 15);
        DataSeries dataSeries = dataContext.getDataSeries();
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Double d2 = dataSeries.ma(Enums.MAMethod.EMA, n2, n3, object);
        dataSeries.setDouble(n2, (Object)TRIX$Values.MA1, d2);
        if (n2 < n3 * 2) {
            return;
        }
        Double d3 = dataSeries.ma(Enums.MAMethod.EMA, n2, n3, (Object)TRIX$Values.MA1);
        dataSeries.setDouble(n2, (Object)TRIX$Values.MA2, d3);
        if (n2 < n3 * 3) {
            return;
        }
        Double d4 = dataSeries.ma(Enums.MAMethod.EMA, n2, n3, (Object)TRIX$Values.MA2);
        dataSeries.setDouble(n2, (Object)TRIX$Values.MA3, d4);
        if (n2 <= n3 * 3) {
            return;
        }
        Double d5 = dataSeries.getDouble(n2 - 1, (Object)TRIX$Values.MA3);
        if (d4 == null || d5 == null) {
            return;
        }
        double d6 = 100.0 * ((d4 - d5) / d5);
        dataSeries.setDouble(n2, (Object)TRIX$Values.TRIX, Double.valueOf(d6));
        int n4 = this.getSettings().getInteger("period2", 9);
        if (n2 <= n3 * 3 + n4) {
            return;
        }
        Double d7 = dataSeries.ma(Enums.MAMethod.EMA, n2, n4, (Object)TRIX$Values.TRIX);
        if (d7 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)TRIX$Values.SIGNAL, d7);
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d7.doubleValue());
        if (this.crossedAbove(dataSeries, n2, (Object)TRIX$Values.TRIX, (Object)TRIX$Values.SIGNAL)) {
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("SIGNAL_TRIX_CROSS_ABOVE", new Object[]{d6, d7});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)TRIX$Signals.CROSS_ABOVE, string, (Object)d7);
        } else if (this.crossedBelow(dataSeries, n2, (Object)TRIX$Values.TRIX, (Object)TRIX$Values.SIGNAL)) {
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("SIGNAL_TRIX_CROSS_BELOW", new Object[]{d6, d7});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)TRIX$Signals.CROSS_BELOW, string, (Object)d7);
        }
        dataSeries.setComplete(n2);
    }
}

