/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Settings;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.TDI$Signals;
import com.motivewave.platform.study.general.TDI$Values;

@StudyHeader(namespace="com.motivewave", id="TDI", rb="com.motivewave.platform.study.nls.strings", name="TITLE_TDI", label="LBL_TDI", desc="DESC_TDI", menu="MENU_GENERAL", overlay=false, studyOverlay=true, signals=true, helpLink="https://www.earnforex.com/metatrader-indicators/Traders-Dynamic-Index/")
public class TDI
extends Study {
    static final String a = "rsiInput";
    static final String b = "rsiPeriod";
    static final String c = "rsiMethod";
    static final String d = "s1Method";
    static final String e = "s1Period";
    static final String f = "s1Line";
    static final String g = "s1Ind";
    static final String h = "s2Method";
    static final String i = "s2Period";
    static final String j = "s2Line";
    static final String k = "s2Ind";
    static final String l = "volPeriod";
    static final String m = "stdDev";
    static final String n = "topLine";
    static final String o = "topInd";
    static final String p = "midLine";
    static final String q = "midInd";
    static final String r = "botLine";
    static final String s = "botInd";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_INPUTS", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup("");
        settingGroup.addRow(new SettingDescriptor[]{this.a((SettingDescriptor)new InputDescriptor(a, this.get("LBL_RSI", new Object[0]), (Object)Enums.BarInput.CLOSE), 2), new MAMethodDescriptor(c, this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMMA), new IntegerDescriptor(b, this.get("LBL_PERIOD", new Object[0]), 14, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor(d, this.get("LBL_TDI_PRICE", new Object[0]), Enums.MAMethod.SMA), this.a((SettingDescriptor)new IntegerDescriptor(e, this.get("LBL_PERIOD", new Object[0]), 2, 1, 9999, 1), 2)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor(h, this.get("LBL_TDI_TRADE_SIGNAL", new Object[0]), Enums.MAMethod.SMA), this.a((SettingDescriptor)new IntegerDescriptor(i, this.get("LBL_PERIOD", new Object[0]), 7, 1, 9999, 1), 2)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(l, this.get("LBL_TDI_VOLATILITY_BAND", new Object[0]), 34, 1, 9999, 1), this.a((SettingDescriptor)new DoubleDescriptor(m, this.get("LBL_TDI_STD", new Object[0]), 1.6185, 1.0E-4, 999.0, 1.0E-4), 2)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(f, this.get("LBL_TDI_PRICE_LINE", new Object[0]), defaults.getGreenLine(), 2.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(g, this.get("LBL_TDI_PRICE_IND", new Object[0]), defaults.getGreenLine(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(j, this.get("LBL_TDI_TRADE_SIGNAL", new Object[0]), defaults.getRedLine(), 2.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(k, this.get("LBL_TDI_TRADE_IND", new Object[0]), defaults.getRedLine(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(n, this.get("LBL_TDI_TOP_LINE", new Object[0]), defaults.getBlueLine(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(o, this.get("LBL_TDI_TOP_IND", new Object[0]), defaults.getBlueLine(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(p, this.get("LBL_TDI_MID_LINE", new Object[0]), defaults.getYellowLine(), 2.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(q, this.get("LBL_TDI_MID_IND", new Object[0]), defaults.getYellowLine(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(r, this.get("LBL_TDI_BOT_LINE", new Object[0]), defaults.getBlueLine(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(s, this.get("LBL_TDI_BOT_IND", new Object[0]), defaults.getBlueLine(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("LBL_MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_ADVANCED", new Object[0]));
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 70.0, 1.0, 100.0, 1.0, true)});
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide2", this.get("LBL_TOP_GUIDE2", new Object[0]), 60.0, 1.0, 100.0, 1.0, true);
        guideDescriptor.setEnabled(false);
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("LBL_MIDDLE_GUIDE", new Object[0]), 50.0, 1.0, 100.0, 1.0, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor2});
        guideDescriptor = new GuideDescriptor("bottomGuide2", this.get("LBL_BOTTOM_GUIDE2", new Object[0]), 40.0, 1.0, 100.0, 1.0, true);
        guideDescriptor.setEnabled(false);
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), 30.0, 1.0, 100.0, 1.0, true)});
        settingsDescriptor.addQuickSettings(new String[]{a, c});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(b, this.get("LBL_PERIOD", new Object[0]), 14, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{d});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(e, this.get("LBL_PERIOD", new Object[0]), 2, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{h});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(i, this.get("LBL_PERIOD", new Object[0]), 7, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(l, this.get("LBL_TDI_VOLATILITY_BAND", new Object[0]), 34, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{m, f, j, n, p, r});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{a, c, b, d, e, h, i, l, m});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TDI$Values.S1, this.get("LBL_TDI_PRICE_LINE", new Object[0]), new String[]{d, e}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TDI$Values.S2, this.get("LBL_TDI_TRADE_SIGNAL", new Object[0]), new String[]{h, i}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TDI$Values.VOL_TOP, this.get("LBL_TDI_VOL_TOP", new Object[0]), new String[]{l, m}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TDI$Values.VOL_MID, this.get("LBL_TDI_VOL_MID", new Object[0]), new String[]{l, m}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TDI$Values.VOL_BOT, this.get("LBL_TDI_VOL_BOT", new Object[0]), new String[]{l, m}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TDI$Signals.CROSS_ABOVE, Enums.ValueType.BOOLEAN, this.get("LBL_TDI_CROSS_ABOVE", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)TDI$Signals.CROSS_BELOW, Enums.ValueType.BOOLEAN, this.get("LBL_TDI_CROSS_BELOW", new Object[0]), new String[0]));
        runtimeDescriptor.declarePath((Object)TDI$Values.S1, f);
        runtimeDescriptor.declareIndicator((Object)TDI$Values.S1, g);
        runtimeDescriptor.declarePath((Object)TDI$Values.S2, j);
        runtimeDescriptor.declareIndicator((Object)TDI$Values.S2, k);
        runtimeDescriptor.declarePath((Object)TDI$Values.VOL_TOP, n);
        runtimeDescriptor.declareIndicator((Object)TDI$Values.VOL_TOP, o);
        runtimeDescriptor.declarePath((Object)TDI$Values.VOL_MID, p);
        runtimeDescriptor.declareIndicator((Object)TDI$Values.VOL_MID, q);
        runtimeDescriptor.declarePath((Object)TDI$Values.VOL_BOT, r);
        runtimeDescriptor.declareIndicator((Object)TDI$Values.VOL_BOT, s);
        runtimeDescriptor.setMaxBottomValue(Integer.valueOf(15));
        runtimeDescriptor.setMinTopValue(Integer.valueOf(85));
        runtimeDescriptor.setRangeKeys(new Object[]{TDI$Values.S1, TDI$Values.S2, TDI$Values.VOL_TOP, TDI$Values.VOL_BOT});
        runtimeDescriptor.declareSignal((Object)TDI$Signals.CROSS_ABOVE, this.get("LBL_TDI_CROSS_ABOVE", new Object[0]));
        runtimeDescriptor.declareSignal((Object)TDI$Signals.CROSS_BELOW, this.get("LBL_TDI_CROSS_BELOW", new Object[0]));
        runtimeDescriptor.setMinTick(Double.valueOf(0.01));
    }

    private SettingDescriptor a(SettingDescriptor settingDescriptor, int n2) {
        settingDescriptor.setGridWidth(n2);
        return settingDescriptor;
    }

    protected void calculate(int n2, DataContext dataContext) {
        Settings settings = this.getSettings();
        int n3 = settings.getInteger(b, 14);
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Object object = settings.getInput(a);
        double d2 = dataSeries.getDouble(n2, object) - dataSeries.getDouble(n2 - 1, object);
        double d3 = 0.0;
        double d4 = 0.0;
        if (d2 > 0.0) {
            d3 = d2;
        } else {
            d4 = d2;
        }
        dataSeries.setDouble(n2, (Object)TDI$Values.UP, Double.valueOf(d3));
        dataSeries.setDouble(n2, (Object)TDI$Values.DOWN, Double.valueOf(Math.abs(d4)));
        if (n2 < n3 + 1) {
            return;
        }
        Enums.MAMethod mAMethod = settings.getMAMethod(c);
        Double d5 = dataSeries.ma(mAMethod, n2, n3, (Object)TDI$Values.UP);
        Double d6 = dataSeries.ma(mAMethod, n2, n3, (Object)TDI$Values.DOWN);
        if (d5 == null || d6 == null) {
            return;
        }
        double d7 = d5 / d6;
        double d8 = 100.0 - 100.0 / (1.0 + d7);
        dataSeries.setDouble(n2, (Object)TDI$Values.RSI, Double.valueOf(d8));
        int n4 = settings.getInteger(e, 2);
        if (n2 < n3 + n4) {
            return;
        }
        Double d9 = dataSeries.ma(settings.getMAMethod(d), n2, n4, (Object)TDI$Values.RSI);
        dataSeries.setDouble(n2, (Object)TDI$Values.S1, d9);
        int n5 = settings.getInteger(i, 7);
        if (n2 < n3 + n5) {
            return;
        }
        Double d10 = dataSeries.ma(settings.getMAMethod(h), n2, n5, (Object)TDI$Values.RSI);
        dataSeries.setDouble(n2, (Object)TDI$Values.S2, d10);
        int n6 = settings.getInteger(l, 34);
        double d11 = settings.getDouble(m, 1.6185);
        if (n2 < n3 + n6) {
            return;
        }
        Double d12 = dataSeries.std(n2, n6, (Object)TDI$Values.RSI);
        Double d13 = dataSeries.ma(mAMethod, n2, n6, (Object)TDI$Values.RSI);
        if (d12 == null || d13 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)TDI$Values.VOL_TOP, Double.valueOf(d13 + d12 * d11));
        dataSeries.setDouble(n2, (Object)TDI$Values.VOL_MID, d13);
        dataSeries.setDouble(n2, (Object)TDI$Values.VOL_BOT, Double.valueOf(d13 - d12 * d11));
        boolean bl2 = n2 == dataSeries.size() - 1;
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d10.doubleValue());
        if (this.crossedAbove(dataSeries, n2, (Object)TDI$Values.S1, (Object)TDI$Values.S2)) {
            boolean bl3 = dataSeries.getBoolean(n2, (Object)TDI$Signals.CROSS_ABOVE, false) && bl2;
            dataSeries.setBoolean(n2, (Object)TDI$Signals.CROSS_ABOVE, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("SIGNAL_TDI_CROSS_ABOVE", new Object[]{this.format(d9), this.format(d10), this.format(dataSeries.getClose(n2))});
            if (!bl3 && markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)TDI$Signals.CROSS_ABOVE, string, (Object)this.round(d9));
        } else if (this.crossedBelow(dataSeries, n2, (Object)TDI$Values.S1, (Object)TDI$Values.S2)) {
            boolean bl4 = dataSeries.getBoolean(n2, (Object)TDI$Signals.CROSS_BELOW, false) && bl2;
            dataSeries.setBoolean(n2, (Object)TDI$Signals.CROSS_BELOW, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("SIGNAL_TDI_CROSS_BELOW", new Object[]{this.format(d9), this.format(d10), this.format(dataSeries.getClose(n2))});
            if (!bl4 && markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)TDI$Signals.CROSS_BELOW, string, (Object)this.round(d9));
        }
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

