/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.StdErrorPerCentA$Values;
import com.motivewave.platform.study.general.j;

@StudyHeader(namespace="com.motivewave", id="ID_SEPA", rb="com.motivewave.platform.study.nls.strings2", label="LBL_SEPA", name="NAME_STANDARD_ERROR_PERCENT_AVERAGE", desc="DESC_SEPA", helpLink="http://www.motivewave.com/studies/standard_error_percenta.htm", signals=false, overlay=false, studyOverlay=true)
public class StdErrorPerCentA
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD1", new Object[0]), 21, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERIOD2", new Object[0]), 3, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        settingGroup2 = settingTab.addGroup(this.get("INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -999.1, 999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup2 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD1", new Object[0]), 21, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("PERIOD2", new Object[0]), 3, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StdErrorPerCentA$Values.PA, this.get("LBL_SEPA", new Object[0]), new String[]{"input", "period", "period2"}));
        runtimeDescriptor.declarePath((Object)StdErrorPerCentA$Values.PA, "line");
        runtimeDescriptor.declareIndicator((Object)StdErrorPerCentA$Values.PA, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{StdErrorPerCentA$Values.PA});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(Math.max(n2, n3) * 2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        int n4 = this.getSettings().getInteger("period");
        int n5 = Math.max(n4, n3 = this.getSettings().getInteger("period2").intValue());
        if (n2 < n5) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double[] dArray = j.a(dataSeries, n2, n4, object);
        double d3 = dArray[0];
        double d4 = dArray[1];
        double d5 = dArray[2];
        double d6 = dArray[3];
        double d7 = dArray[4];
        double d8 = dArray[5];
        double d9 = 0.0;
        double d10 = d5 - (double)n4 * d7 * d8;
        double d11 = d6 - (double)n4 * d7 * d7;
        double d12 = d10 / d11;
        double d13 = d8 - d12 * d7;
        double d14 = d4 - d13 * d3 - d12 * d5;
        double d15 = n4 - 2;
        double d16 = d14 / d15;
        d9 = dataSeries.getDouble(n2 - 1, (Object)StdErrorPerCentA$Values.SDER, 0.0);
        double[] dArray2 = j.a(dataSeries, n2, n3, object, 0);
        double d17 = dArray2[0];
        dataSeries.setDouble(n2, (Object)StdErrorPerCentA$Values.LIN_REG, Double.valueOf(d17));
        if (d16 > 0.0) {
            d9 = Math.sqrt(d16);
        }
        dataSeries.setDouble(n2, (Object)StdErrorPerCentA$Values.SDER, Double.valueOf(d9));
        if (n2 < n5 * 2) {
            return;
        }
        double d18 = dataSeries.sma(n2, n3, (Object)StdErrorPerCentA$Values.LIN_REG);
        double d19 = 2.0 * dataSeries.sma(n2, n3, (Object)StdErrorPerCentA$Values.SDER);
        double d20 = (d2 - (d18 - d19)) / (d18 + d19 - (d18 - d19)) * 100.0;
        dataSeries.setDouble(n2, (Object)StdErrorPerCentA$Values.PA, Double.valueOf(d20));
        dataSeries.setComplete(n2);
    }
}

