/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.SmoothedRateOfChange$Signals;
import com.motivewave.platform.study.general.SmoothedRateOfChange$Values;

@StudyHeader(namespace="com.motivewave", id="SMOOTH_ROC", rb="com.motivewave.platform.study.nls.strings", name="TITLE_SMOOTH_ROC", label="LABEL_SMOOTH_ROC", tabName="TAB_SMOOTH_ROC", desc="DESC_SMOOTH_ROC", menu="MENU_GENERAL", overlay=false, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/rate_of_change.htm")
public class SmoothedRateOfChange
extends Study {
    static final String a = "smoothMethod";
    static final String b = "smoothPeriod";
    static final String c = "compPeriod";
    static final String d = "signalPeriod";
    static final String e = "signalMethod";
    static final String f = "rocLine";
    static final String g = "maLine";
    static final String h = "rocInd";
    static final String i = "maInd";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b, this.get("LBL_SMOOTH_PERIOD", new Object[0]), 10, 1, 9999, 1), new MAMethodDescriptor(a, this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(c, this.get("LBL_COMP_PERIOD", new Object[0]), 12, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(d, this.get("LBL_SIGNAL_PERIOD", new Object[0]), 20, 1, 9999, 1), new MAMethodDescriptor(e, this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_DISPLAY", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor(f, this.get("LBL_ROC_LINE", new Object[0]), defaults.getLineColor(), 1.5f, null, true, false, false);
        pathDescriptor.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), f, 0.0, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), f, 0.0, Enums.ShadeType.BELOW, defaults.getBottomFillColor(), false, true)});
        PathDescriptor pathDescriptor2 = new PathDescriptor(g, this.get("LBL_SIGNAL_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, false);
        pathDescriptor2.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor2});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(h, this.get("LBL_ROC_IND", new Object[0]), null, null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(i, this.get("LBL_SIGNAL_IND", new Object[0]), null, null, false, false, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(b, this.get("LBL_SMOOTH_PERIOD", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(c, this.get("LBL_COMP_PERIOD", new Object[0]), 12, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor(d, this.get("LBL_SIGNAL_PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{e, f, g, "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{b, a, c, d, e});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SmoothedRateOfChange$Values.ROC, this.get("VAL_ROC", new Object[0]), new String[]{a, b, c}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SmoothedRateOfChange$Values.SIGNAL, this.get("VAL_ROC_MA", new Object[0]), new String[]{e, d}));
        runtimeDescriptor.declarePath((Object)SmoothedRateOfChange$Values.ROC, f);
        runtimeDescriptor.declarePath((Object)SmoothedRateOfChange$Values.SIGNAL, g);
        runtimeDescriptor.declareIndicator((Object)SmoothedRateOfChange$Values.ROC, h);
        runtimeDescriptor.declareIndicator((Object)SmoothedRateOfChange$Values.SIGNAL, i);
        runtimeDescriptor.declareSignal((Object)SmoothedRateOfChange$Signals.CROSS_ABOVE, this.get("LBL_CROSS_ABOVE_SIGNAL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)SmoothedRateOfChange$Signals.CROSS_BELOW, this.get("LBL_CROSS_BELOW_SIGNAL", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{SmoothedRateOfChange$Values.ROC, SmoothedRateOfChange$Values.SIGNAL});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, null));
    }

    protected void calculate(int n2, DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        int n3 = this.getSettings().getInteger(b, 10);
        if (n2 < n3) {
            return;
        }
        Double d2 = dataSeries.ma(this.getSettings().getMAMethod(a, Enums.MAMethod.SMA), n2, n3, this.getSettings().getInput("input"));
        if (d2 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)SmoothedRateOfChange$Values.MA, d2);
        int n4 = this.getSettings().getInteger(c, 12);
        if (n2 < n3 + n4) {
            return;
        }
        Double d3 = dataSeries.roc(n2, n4, (Object)SmoothedRateOfChange$Values.MA);
        if (d3 == null) {
            return;
        }
        d3 = d3 * 100.0;
        dataSeries.setDouble(n2, (Object)SmoothedRateOfChange$Values.ROC, d3);
        int n5 = this.getSettings().getInteger(d, 20);
        if (n2 < n3 + n4 + n5) {
            return;
        }
        Double d4 = dataSeries.ma(this.getSettings().getMAMethod(e, Enums.MAMethod.EMA), n2, n5, (Object)SmoothedRateOfChange$Values.ROC);
        if (d4 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)SmoothedRateOfChange$Values.SIGNAL, d4);
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d4.doubleValue());
        if (this.crossedAbove(dataSeries, n2, (Object)SmoothedRateOfChange$Values.ROC, (Object)SmoothedRateOfChange$Values.SIGNAL)) {
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("SIGNAL_ROC_CROSS_ABOVE", new Object[]{d3, d4});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)SmoothedRateOfChange$Signals.CROSS_ABOVE, string, (Object)d4);
        } else if (this.crossedBelow(dataSeries, n2, (Object)SmoothedRateOfChange$Values.ROC, (Object)SmoothedRateOfChange$Values.SIGNAL)) {
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("SIGNAL_ROC_CROSS_BELOW", new Object[]{d3, d4});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)SmoothedRateOfChange$Signals.CROSS_BELOW, string, (Object)d4);
        }
        dataSeries.setComplete(n2);
    }
}

