/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Bar;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.NVP;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.DiscreteDescriptor;
import com.motivewave.platform.sdk.common.desc.EnabledDependency;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDependency;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.Seasonality$Values;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="SEASONALITY", rb="com.motivewave.platform.study.nls.strings", name="TITLE_SEASONALITY", desc="DESC_SEASONALITY", menu="MENU_GENERAL", overlay=false)
public class Seasonality
extends Study {
    static final String a = "years";
    static final String b = "calcMethod";
    static final String c = "SOY";
    static final String d = "SOM";
    static final String e = "project";
    private boolean a = false;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        ArrayList<NVP> arrayList = new ArrayList<NVP>();
        arrayList.add(new NVP(this.get("LBL_START_OF_YEAR", new Object[0]), c));
        arrayList.add(new NVP(this.get("LBL_START_OF_MONTH", new Object[0]), d));
        SettingGroup settingGroup = settingTab.addGroup("", false);
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_YEARS", new Object[0]), 10, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object[])new Enums.BarInput[]{Enums.BarInput.OPEN, Enums.BarInput.CLOSE, Enums.BarInput.MIDPOINT, Enums.BarInput.HIGH, Enums.BarInput.LOW, Enums.BarInput.TP}, (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new DiscreteDescriptor(b, this.get("LBL_CALC_METHOD", new Object[0]), c, arrayList)});
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingGroup.addRow(new SettingDescriptor[0]);
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("LBL_PROJECTED_LINE", new Object[0]), defaults.getLineColor(), 1.0f, new float[]{3.0f, 3.0f}), new BooleanDescriptor(e, this.get("LBL_ENABLED", new Object[0]), Boolean.valueOf(true), false)});
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency(e, new String[]{"line2"}));
        settingsDescriptor.addQuickSettings(new String[]{a, "input", b, "line", "line2", e});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{a, b});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Seasonality$Values.PER, this.get("LBL_PER_GAIN", new Object[0]), new String[]{a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Seasonality$Values.PPER, this.get("LBL_PER_GAIN", new Object[0]), new String[]{a}));
        runtimeDescriptor.declarePath((Object)Seasonality$Values.PER, "line");
        runtimeDescriptor.declarePath((Object)Seasonality$Values.PPER, "line2");
        runtimeDescriptor.declareIndicator((Object)Seasonality$Values.PER, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{Seasonality$Values.PER, Seasonality$Values.PPER});
        runtimeDescriptor.setMinTick(Double.valueOf(0.01));
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
    }

    protected void calculateValues(DataContext dataContext) {
        super.calculateValues(dataContext);
        DataSeries dataSeries = dataContext.getDataSeries();
        BarSize barSize = dataSeries.getBarSize();
        if (!barSize.isLinear() || barSize.getIntervalMinutes() != 1440 || this.a) {
            return;
        }
        this.a = true;
        Util.schedule(() -> {
            try {
                this.a(dataContext);
            }
            finally {
                this.a = false;
            }
        });
    }

    private void a(DataContext dataContext) {
        int n2;
        List list;
        int n3;
        int n4;
        DataSeries dataSeries = dataContext.getDataSeries();
        BarSize barSize = dataSeries.getBarSize();
        int n5 = this.getSettings().getInteger(a, 10);
        Enums.BarInput barInput = (Enums.BarInput)this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        boolean bl2 = Util.compare((Object)this.getSettings().getString(b), (Object)c);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(dataSeries.getStartTime(0) - (long)n5 * 31557600000L);
        int n6 = calendar.get(1);
        calendar.clear();
        calendar.set(1, n6);
        long l2 = calendar.getTimeInMillis();
        Instrument instrument = dataSeries.getInstrument();
        List list2 = null;
        try {
            list2 = instrument.getBars(l2, dataContext.getCurrentTime(), barSize, dataContext.isRTH());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        calendar.setTimeInMillis(((Bar)list2.get(0)).getStartTime() + 43200000L);
        int n7 = calendar.get(1);
        HashMap<Long, Bar> hashMap = new HashMap<Long, Bar>();
        HashMap<Integer, ArrayList<Bar>> hashMap2 = new HashMap<Integer, ArrayList<Bar>>();
        HashMap<CallSite, ArrayList<Bar>> hashMap3 = new HashMap<CallSite, ArrayList<Bar>>();
        for (Bar bar : list2) {
            calendar.setTimeInMillis(bar.getStartTime() + 43200000L);
            n4 = calendar.get(1);
            int n8 = calendar.get(2);
            hashMap.put(bar.getStartTime(), bar);
            ArrayList<Bar> arrayList = (ArrayList<Bar>)hashMap2.get(n4);
            if (arrayList == null) {
                arrayList = new ArrayList<Bar>();
                hashMap2.put(n4, arrayList);
            }
            arrayList.add(bar);
            ArrayList<Bar> arrayList2 = (ArrayList<Bar>)hashMap3.get(n4 + ":" + n8);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<Bar>();
                hashMap3.put((CallSite)((Object)(n4 + ":" + n8)), arrayList2);
            }
            arrayList2.add(bar);
        }
        for (n3 = 0; n3 < dataSeries.size(); ++n3) {
            if (dataSeries.isComplete(n3)) continue;
            calendar.setTimeInMillis(dataSeries.getStartTime(n3) + 43200000L);
            int n9 = calendar.get(1);
            n4 = calendar.get(2);
            double d2 = 0.0;
            int n10 = 0;
            if (bl2) {
                list = (List)hashMap2.get(n9);
                var24_32 = (Bar)hashMap.get(dataSeries.getStartTime(n3));
                if (list == null || var24_32 == null || (n2 = list.indexOf(var24_32)) < 0) continue;
                for (var26_36 = n9; var26_36 >= n7; --var26_36) {
                    list = (List)hashMap2.get(var26_36);
                    if (list == null) continue;
                    var27_39 = this.a((Bar)list.get(0), barInput);
                    var24_32 = n2 < list.size() ? (Bar)list.get(n2) : (Bar)list.get(list.size() - 1);
                    d2 += (double)((this.a(var24_32, barInput) - var27_39) / var27_39);
                    ++n10;
                }
            } else {
                list = (List)hashMap3.get(n9 + ":" + n4);
                var24_32 = (Bar)hashMap.get(dataSeries.getStartTime(n3));
                if (list == null || var24_32 == null || (n2 = list.indexOf(var24_32)) < 0) continue;
                for (var26_36 = n9; var26_36 >= n7; --var26_36) {
                    list = (List)hashMap3.get(var26_36 + ":" + n4);
                    if (list == null) continue;
                    var27_39 = this.a((Bar)list.get(0), barInput);
                    var24_32 = n2 < list.size() ? (Bar)list.get(n2) : (Bar)list.get(list.size() - 1);
                    d2 += (double)((this.a(var24_32, barInput) - var27_39) / var27_39);
                    ++n10;
                }
            }
            if (n10 == 0) continue;
            dataSeries.setDouble(n3, (Object)Seasonality$Values.PER, Double.valueOf(100.0 * (d2 / (double)n10)));
            dataSeries.setComplete(n3, dataSeries.isBarComplete(n3));
        }
        if (!this.getSettings().is(e)) {
            return;
        }
        for (n3 = dataSeries.size(); n3 < dataSeries.size() + 400; ++n3) {
            calendar.setTimeInMillis(dataSeries.getStartTime(n3) + 43200000L);
            int n11 = calendar.get(1) - 1;
            n4 = calendar.get(2);
            double d3 = 0.0;
            int n12 = 0;
            if (bl2) {
                list = (List)hashMap2.get(n11);
                if (list == null || (var24_34 = Util.findNearest((List)list, (long)(dataSeries.getStartTime(n3) - 31557600000L))) < 0) continue;
                for (n2 = n11; n2 >= n7; --n2) {
                    list = (List)hashMap2.get(n2);
                    if (list == null) continue;
                    var26_38 = this.a((Bar)list.get(0), barInput);
                    var27_41 = var24_34 < list.size() ? (Bar)list.get(var24_34) : (Bar)list.get(list.size() - 1);
                    d3 += (double)((this.a(var27_41, barInput) - var26_38) / var26_38);
                    ++n12;
                }
            } else {
                list = (List)hashMap3.get(n11 + ":" + n4);
                if (list == null || (var24_34 = Util.findNearest((List)list, (long)(dataSeries.getStartTime(n3) - 31557600000L))) < 0) continue;
                for (n2 = n11; n2 >= n7; --n2) {
                    list = (List)hashMap3.get(n2 + ":" + n4);
                    if (list == null) continue;
                    var26_38 = this.a((Bar)list.get(0), barInput);
                    var27_41 = var24_34 < list.size() ? (Bar)list.get(var24_34) : (Bar)list.get(list.size() - 1);
                    d3 += (double)((this.a(var27_41, barInput) - var26_38) / var26_38);
                    ++n12;
                }
            }
            if (n12 == 0) continue;
            dataSeries.setDouble(n3, (Object)Seasonality$Values.PPER, Double.valueOf(100.0 * (d3 / (double)n12)));
            dataSeries.setComplete(n3, false);
        }
    }

    private float a(Bar bar, Enums.BarInput barInput) {
        switch (barInput) {
            case OPEN: {
                return bar.getOpen();
            }
            case CLOSE: {
                return bar.getClose();
            }
            case HIGH: {
                return bar.getHigh();
            }
            case LOW: {
                return bar.getLow();
            }
            case MIDPOINT: {
                return (bar.getHigh() + bar.getLow()) / 2.0f;
            }
            case TP: {
                return (bar.getLow() + bar.getHigh() + bar.getClose()) / 3.0f;
            }
        }
        return 0.0f;
    }
}

