/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.RelativeVolatilityIndex$Signals;
import com.motivewave.platform.study.general.RelativeVolatilityIndex$Values;

@StudyHeader(namespace="com.motivewave", id="ID_RVI", rb="com.motivewave.platform.study.nls.strings2", name="NAME_RELATIVE_VOLATILITY_INDEX", label="LBL_RVI", desc="DESC_RVI", helpLink="http://www.motivewave.com/studies/relative_volatility_index.htm", signals=true, overlay=false, studyOverlay=true)
public class RelativeVolatilityIndex
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("STD_DEV_PERIOD", new Object[0]), 10, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("SMOOTH_PERIOD", new Object[0]), 14, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_RVI", new Object[0]), defaults.getLineColor(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 70.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 30.0, 0.0, 999.1, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingGroup2 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "topGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "bottomGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("STD_DEV_PERIOD", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("SMOOTH_PERIOD", new Object[0]), 14, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "method", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RelativeVolatilityIndex$Values.RVI, this.get("RVI", new Object[0]), new String[]{"input", "period", "method"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RelativeVolatilityIndex$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RelativeVolatilityIndex$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declarePath((Object)RelativeVolatilityIndex$Values.RVI, "line");
        runtimeDescriptor.declareIndicator((Object)RelativeVolatilityIndex$Values.RVI, "ind");
        runtimeDescriptor.declareSignal((Object)RelativeVolatilityIndex$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)RelativeVolatilityIndex$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{RelativeVolatilityIndex$Values.RVI});
        runtimeDescriptor.setMaxBottomValue(Integer.valueOf(15));
        runtimeDescriptor.setMinTopValue(Integer.valueOf(85));
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        DataSeries dataSeries = dataContext.getDataSeries();
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        if (n2 <= n3) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        double d2 = dataSeries.getHigh(n2);
        double d3 = dataSeries.getLow(n2);
        double d4 = dataSeries.getHigh(n2 - 1);
        double d5 = dataSeries.getLow(n2 - 1);
        double d6 = dataSeries.std(n2, n3, (Object)Enums.BarInput.HIGH);
        double d7 = dataSeries.std(n2, n3, (Object)Enums.BarInput.LOW);
        double d8 = d2 > d4 ? d6 : 0.0;
        double d9 = d2 < d4 ? d6 : 0.0;
        double d10 = d3 > d5 ? d7 : 0.0;
        double d11 = d3 < d5 ? d7 : 0.0;
        dataSeries.setDouble(n2, (Object)RelativeVolatilityIndex$Values.STD_HIGH_UP, Double.valueOf(Math.abs(d8)));
        dataSeries.setDouble(n2, (Object)RelativeVolatilityIndex$Values.STD_HIGH_DOWN, Double.valueOf(Math.abs(d9)));
        dataSeries.setDouble(n2, (Object)RelativeVolatilityIndex$Values.STD_LOW_UP, Double.valueOf(Math.abs(d10)));
        dataSeries.setDouble(n2, (Object)RelativeVolatilityIndex$Values.STD_LOW_DOWN, Double.valueOf(Math.abs(d11)));
        if (n2 <= n4 + n3) {
            return;
        }
        double d12 = Util.toDouble((Object)dataSeries.ma(mAMethod, n2, n4, (Object)RelativeVolatilityIndex$Values.STD_HIGH_UP));
        double d13 = Util.toDouble((Object)dataSeries.ma(mAMethod, n2, n4, (Object)RelativeVolatilityIndex$Values.STD_HIGH_DOWN));
        double d14 = Util.toDouble((Object)dataSeries.ma(mAMethod, n2, n4, (Object)RelativeVolatilityIndex$Values.STD_LOW_UP));
        double d15 = Util.toDouble((Object)dataSeries.ma(mAMethod, n2, n4, (Object)RelativeVolatilityIndex$Values.STD_LOW_DOWN));
        double d16 = d12 + d13 == 0.0 ? 50.0 : 100.0 * d12 / (d12 + d13);
        double d17 = d14 + d15 == 0.0 ? 50.0 : 100.0 * d14 / (d14 + d15);
        double d18 = (d16 + d17) / 2.0;
        dataSeries.setDouble(n2, (Object)RelativeVolatilityIndex$Values.RVI, Double.valueOf(d18));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        if (this.crossedAbove(dataSeries, n2, (Object)RelativeVolatilityIndex$Values.RVI, guideInfo.getValue())) {
            dataSeries.setBoolean(n2, (Object)RelativeVolatilityIndex$Signals.SELL, Boolean.valueOf(true));
            Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d18);
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("SIGNAL_RVI_TOP", new Object[]{guideInfo.getValue(), this.round(d18)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RelativeVolatilityIndex$Signals.SELL, string, (Object)this.round(d18));
        } else if (this.crossedBelow(dataSeries, n2, (Object)RelativeVolatilityIndex$Values.RVI, guideInfo2.getValue())) {
            dataSeries.setBoolean(n2, (Object)RelativeVolatilityIndex$Signals.BUY, Boolean.valueOf(true));
            Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d18);
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("SIGNAL_RVI_TOP", new Object[]{guideInfo2.getValue(), this.round(d18)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RelativeVolatilityIndex$Signals.BUY, string, (Object)this.round(d18));
        }
        dataSeries.setComplete(n2);
    }
}

