/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.RelativeVigorIndex$Signals;
import com.motivewave.platform.study.general.RelativeVigorIndex$Values;

@StudyHeader(namespace="com.motivewave", id="REL_VIGOR", rb="com.motivewave.platform.study.nls.strings", name="TITLE_REL_VIGOR", tabName="TAB_REL_VIGOR", desc="DESC_REL_VIGOR", menu="MENU_GENERAL", overlay=false, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/relative_vigor_index.htm")
public class RelativeVigorIndex
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 10, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 4, 1, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_DISPLAY", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.5f, null, true, false, false);
        pathDescriptor.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        PathDescriptor pathDescriptor2 = new PathDescriptor("signalLine", this.get("LBL_SIGNAL_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, false);
        pathDescriptor2.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor2});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("signalInd", this.get("LBL_SIGNAL_IND", new Object[0]), null, null, false, false, true)});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 4, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "signalLine"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RelativeVigorIndex$Values.VAL, this.get("VAL_REL_VIGOR", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RelativeVigorIndex$Values.SIGNAL, this.get("VAL_REL_VIGOR_SIGNAL", new Object[0]), new String[]{"period2"}));
        runtimeDescriptor.declarePath((Object)RelativeVigorIndex$Values.VAL, "line");
        runtimeDescriptor.declarePath((Object)RelativeVigorIndex$Values.SIGNAL, "signalLine");
        runtimeDescriptor.declareIndicator((Object)RelativeVigorIndex$Values.VAL, "ind");
        runtimeDescriptor.declareIndicator((Object)RelativeVigorIndex$Values.SIGNAL, "signalInd");
        runtimeDescriptor.declareSignal((Object)RelativeVigorIndex$Signals.CROSS_ABOVE, this.get("LBL_CROSS_ABOVE_SIGNAL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)RelativeVigorIndex$Signals.CROSS_BELOW, this.get("LBL_CROSS_BELOW_SIGNAL", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{RelativeVigorIndex$Values.VAL, RelativeVigorIndex$Values.SIGNAL});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, null));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period", 10);
        int n4 = this.getSettings().getInteger("period2", 4);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = (dataSeries.getClose(n2) - dataSeries.getOpen(n2)) / (dataSeries.getHigh(n2) - dataSeries.getLow(n2));
        dataSeries.setDouble(n2, (Object)RelativeVigorIndex$Values.RVI, Double.valueOf(d2));
        if (n2 < n3) {
            return;
        }
        Double d3 = dataSeries.ma(Enums.MAMethod.SMA, n2, n3, (Object)RelativeVigorIndex$Values.RVI);
        dataSeries.setDouble(n2, (Object)RelativeVigorIndex$Values.VAL, d3);
        if (n2 < n3 + n4) {
            return;
        }
        Double d4 = dataSeries.ma(Enums.MAMethod.WMA, n2, n4, (Object)RelativeVigorIndex$Values.VAL);
        if (d4 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)RelativeVigorIndex$Values.SIGNAL, d4);
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d4.doubleValue());
        if (this.crossedAbove(dataSeries, n2, (Object)RelativeVigorIndex$Values.VAL, (Object)RelativeVigorIndex$Values.SIGNAL)) {
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("SIGNAL_VIGOR_CROSS_ABOVE", new Object[]{d3, d4});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RelativeVigorIndex$Signals.CROSS_ABOVE, string, (Object)d4);
        } else if (this.crossedBelow(dataSeries, n2, (Object)RelativeVigorIndex$Values.VAL, (Object)RelativeVigorIndex$Values.SIGNAL)) {
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("SIGNAL_VIGOR_CROSS_BELOW", new Object[]{d3, d4});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RelativeVigorIndex$Signals.CROSS_BELOW, string, (Object)d4);
        }
        dataSeries.setComplete(n2);
    }
}

