/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.RelativeMonentumIndex$Values;
import com.motivewave.platform.study.general.j;

@StudyHeader(namespace="com.motivewave", id="ID_RMIX", rb="com.motivewave.platform.study.nls.strings2", name="NAME_RELATIVE_MOMENTUM_INDEX", label="LBL_RMIX", desc="DESC_RMIX", helpLink="http://www.motivewave.com/studies/relative_momentum_index.htm", signals=false, overlay=false, studyOverlay=true)
public class RelativeMonentumIndex
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 20, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_RMIX", new Object[0]), defaults.getLineColor(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), null, null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -999.1, 999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RelativeMonentumIndex$Values.RMIX, this.get("LBL_RMIX", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.declarePath((Object)RelativeMonentumIndex$Values.RMIX, "line");
        runtimeDescriptor.declareIndicator((Object)RelativeMonentumIndex$Values.RMIX, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{RelativeMonentumIndex$Values.RMIX});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        double d2;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Object object = this.getSettings().getInput("input");
        double d3 = 0.0;
        double d4 = 0.0;
        d3 = d2 = j.a(dataContext, n2, n3, object);
        d4 = d2;
        double d5 = dataSeries.getDouble(n2 - 1, (Object)RelativeMonentumIndex$Values.MU, d2);
        double d6 = dataSeries.getDouble(n2 - 1, (Object)RelativeMonentumIndex$Values.MD, d2);
        if (d2 >= 0.0) {
            d3 = d5 - d5 / (double)n3 + d2;
        }
        if (d2 <= 0.0) {
            d4 = d6 - d6 / (double)n3 + Math.abs(d2);
        }
        dataSeries.setDouble(n2, (Object)RelativeMonentumIndex$Values.MU, Double.valueOf(d3));
        dataSeries.setDouble(n2, (Object)RelativeMonentumIndex$Values.MD, Double.valueOf(d4));
        double d7 = d3 / d4;
        double d8 = 100.0 * (d7 / (1.0 + d7));
        dataSeries.setDouble(n2, (Object)RelativeMonentumIndex$Values.RMIX, Double.valueOf(d8));
        dataSeries.setComplete(n2);
    }
}

