/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.RMO$Signals;
import com.motivewave.platform.study.general.RMO$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="RMO", rb="com.motivewave.platform.study.nls.strings", name="TITLE_RMO", label="LBL_RMO", desc="DESC_RMO", menu="MENU_GENERAL", overlay=false)
public class RMO
extends Study {
    static final String a = "paintBars";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_SETTINGS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingGroup.addRow(new SettingDescriptor[]{new ColorDescriptor("neutralColor", this.get("LBL_NEUTRAL_COLOR", new Object[0]), defaults.getBlue())});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(a, this.get("LBL_PAINT_PRICE_BARS", new Object[0]), Boolean.valueOf(false), true)});
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_RMO_ST2", new Object[0]), defaults.getGreen(), 1.0f, null, false, false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("LBL_RMO_ST3", new Object[0]), defaults.getRed(), 1.0f, null, false, false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_MARKERS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.ARROW, Enums.Size.SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.ARROW, Enums.Size.SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"upColor", "downColor", "neutralColor", a, "line", "line2"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RMO$Values.RMO, this.get("LBL_RMO", new Object[0]), new String[0]));
        runtimeDescriptor.declareBars((Object)RMO$Values.RMO);
        runtimeDescriptor.declareIndicator((Object)RMO$Values.RMO, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{RMO$Values.RMO, RMO$Values.S2, RMO$Values.S3});
        runtimeDescriptor.declarePath((Object)RMO$Values.S2, "line");
        runtimeDescriptor.declarePath((Object)RMO$Values.S3, "line2");
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        runtimeDescriptor.setPricePlotRequired(true);
        runtimeDescriptor.declareSignal((Object)RMO$Signals.BUY, this.get("LBL_BUY", new Object[0]));
        runtimeDescriptor.declareSignal((Object)RMO$Signals.SELL, this.get("LBL_SELL", new Object[0]));
        this.setMinBars(1000);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 <= 2) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.sma(n2, 2, (Object)Enums.BarInput.CLOSE);
        dataSeries.setDouble(n2, (Object)RMO$Values.MA1, d2);
        Double d3 = dataSeries.sma(n2, 2, (Object)RMO$Values.MA1);
        if (d3 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)RMO$Values.MA2, d3);
        Double d4 = dataSeries.sma(n2, 2, (Object)RMO$Values.MA2);
        if (d4 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)RMO$Values.MA3, d4);
        Double d5 = dataSeries.sma(n2, 2, (Object)RMO$Values.MA3);
        if (d5 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)RMO$Values.MA4, d5);
        Double d6 = dataSeries.sma(n2, 2, (Object)RMO$Values.MA4);
        if (d6 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)RMO$Values.MA5, d6);
        Double d7 = dataSeries.sma(n2, 2, (Object)RMO$Values.MA5);
        if (d7 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)RMO$Values.MA6, d7);
        Double d8 = dataSeries.sma(n2, 2, (Object)RMO$Values.MA6);
        if (d8 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)RMO$Values.MA7, d8);
        Double d9 = dataSeries.sma(n2, 2, (Object)RMO$Values.MA7);
        if (d9 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)RMO$Values.MA8, d9);
        Double d10 = dataSeries.sma(n2, 2, (Object)RMO$Values.MA8);
        if (d10 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)RMO$Values.MA9, d10);
        Double d11 = dataSeries.sma(n2, 2, (Object)RMO$Values.MA9);
        if (d11 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)RMO$Values.MA10, d11);
        double d12 = dataSeries.highest(n2, 10, (Object)Enums.BarInput.CLOSE) - dataSeries.lowest(n2, 10, Enums.BarInput.CLOSE);
        if (d12 == 0.0) {
            return;
        }
        double d13 = 100.0 * ((double)dataSeries.getClose(n2) - (d2 + d3 + d4 + d5 + d6 + d7 + d8 + d9 + d10 + d11) / 10.0) / d12;
        dataSeries.setDouble(n2, (Object)RMO$Values.S1, Double.valueOf(d13));
        Double d14 = dataSeries.ema(n2, 30, (Object)RMO$Values.S1);
        if (d14 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)RMO$Values.S2, d14);
        Double d15 = dataSeries.ema(n2, 30, (Object)RMO$Values.S2);
        if (d15 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)RMO$Values.S3, d15);
        Double d16 = dataSeries.ema(n2, 81, (Object)RMO$Values.S1);
        if (d16 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)RMO$Values.RMO, d16);
        boolean bl2 = d16 > 0.0;
        boolean bl3 = d14 > 0.0;
        boolean bl4 = d14 < 0.0;
        Color color = this.getSettings().getColor("upColor");
        Color color2 = this.getSettings().getColor("downColor");
        Color color3 = this.getSettings().getColor("neutralColor");
        Color color4 = bl3 ? color : (bl4 ? color2 : (bl2 ? color : color3));
        dataSeries.setBarColor(n2, (Object)RMO$Values.RMO, color4);
        if (this.getSettings().is(a)) {
            dataSeries.setPriceBarColor(n2, color4);
        }
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        if (this.crossedAbove(dataSeries, n2, (Object)RMO$Values.S2, (Object)RMO$Values.S3)) {
            Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), (double)dataSeries.getLow(n2));
            dataSeries.setBoolean(n2, (Object)RMO$Signals.BUY, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("SIGNAL_BUY", new Object[]{this.format(d14), this.format(d15), this.format(dataSeries.getClose(n2))});
            if (markerInfo.isEnabled()) {
                this.addFigure("__PRICE__", (Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RMO$Signals.BUY, string, (Object)this.round(d14));
        } else if (this.crossedBelow(dataSeries, n2, (Object)RMO$Values.S2, (Object)RMO$Values.S3)) {
            Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), (double)dataSeries.getHigh(n2));
            dataSeries.setBoolean(n2, (Object)RMO$Signals.SELL, Boolean.valueOf(true));
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("SIGNAL_SELL", new Object[]{this.format(d14), this.format(d15), this.format(dataSeries.getClose(n2))});
            if (markerInfo.isEnabled()) {
                this.addFigure("__PRICE__", (Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RMO$Signals.SELL, string, (Object)this.round(d14));
        }
        dataSeries.setComplete(n2);
    }
}

