/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.ProjectionOscillator$Signals;
import com.motivewave.platform.study.general.ProjectionOscillator$Values;
import com.motivewave.platform.study.general.j;

@StudyHeader(namespace="com.motivewave", id="ID_PBO", rb="com.motivewave.platform.study.nls.strings2", name="NAME_PROJECTION_OSCILLATOR", label="LBL_PBO", desc="DESC_PBO", helpLink="http://www.motivewave.com/studies/projection_oscillator.htm", signals=true, overlay=false, studyOverlay=true)
public class ProjectionOscillator
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PBO_PERIOD", new Object[0]), 14, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("SIGNAL_PERIOD", new Object[0]), 3, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_PBO", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("SIGNAL", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_PBO", new Object[0]), null, null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SIGNAL", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 5.0, -999.01, 999.01, 0.01, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        SettingGroup settingGroup5 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PBO_PERIOD", new Object[0]), 14, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("SIGNAL_PERIOD", new Object[0]), 3, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "line2"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"method", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ProjectionOscillator$Values.PBO, this.get("PL", new Object[0]), new String[]{"method", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ProjectionOscillator$Values.SIG, this.get("PU", new Object[0]), new String[]{"method", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ProjectionOscillator$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ProjectionOscillator$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)ProjectionOscillator$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)ProjectionOscillator$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)ProjectionOscillator$Values.PBO, "line");
        runtimeDescriptor.declarePath((Object)ProjectionOscillator$Values.SIG, "line2");
        runtimeDescriptor.declareIndicator((Object)ProjectionOscillator$Values.PBO, "ind");
        runtimeDescriptor.declareIndicator((Object)ProjectionOscillator$Values.SIG, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{ProjectionOscillator$Values.PBO});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        int n4 = this.getSettings().getInteger("period2");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        DataSeries dataSeries = dataContext.getDataSeries();
        int n5 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = Double.MAX_VALUE;
        double d8 = j.a(dataSeries, n2, n3, Enums.BarInput.HIGH, 0)[1];
        double d9 = j.a(dataSeries, n2, n3, Enums.BarInput.LOW, 0)[1];
        for (int i2 = n2 - n3 + 1; i2 <= n2; ++i2) {
            d2 = dataSeries.getDouble(i2, (Object)Enums.BarInput.HIGH);
            d3 = dataSeries.getDouble(i2, (Object)Enums.BarInput.LOW);
            d4 = d2 + d8 * (double)n5;
            d5 = d3 + d9 * (double)n5;
            ++n5;
            if (d4 > d6) {
                d6 = d4;
            }
            if (!(d5 < d7)) continue;
            d7 = d5;
        }
        double d10 = dataSeries.getDouble(n2, (Object)Enums.BarInput.CLOSE);
        double d11 = 100.0 * (d10 - d7) / (d6 - d7);
        dataSeries.setDouble(n2, (Object)ProjectionOscillator$Values.PBO, Double.valueOf(d11));
        if (n2 < n3 + n4) {
            return;
        }
        Double d12 = dataSeries.ma(mAMethod, n2, n4, (Object)ProjectionOscillator$Values.PBO);
        dataSeries.setDouble(n2, (Object)ProjectionOscillator$Values.SIG, d12);
        boolean bl2 = this.crossedAbove(dataSeries, n2, (Object)ProjectionOscillator$Values.PBO, (Object)ProjectionOscillator$Values.SIG);
        boolean bl3 = this.crossedBelow(dataSeries, n2, (Object)ProjectionOscillator$Values.PBO, (Object)ProjectionOscillator$Values.SIG);
        dataSeries.setBoolean(n2, (Object)ProjectionOscillator$Signals.SELL, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)ProjectionOscillator$Signals.BUY, Boolean.valueOf(bl2));
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d11);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_PBO", new Object[]{Util.round((double)d10, (int)2), Util.round((double)d11, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)ProjectionOscillator$Signals.SELL, string, (Object)d10);
        }
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d11);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_PBO", new Object[]{Util.round((double)d10, (int)2), Util.round((double)d11, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)ProjectionOscillator$Signals.BUY, string, (Object)d10);
        }
        dataSeries.setComplete(n2);
    }
}

