/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.PolynomialRegCh$Values;

@StudyHeader(namespace="com.motivewave", id="ID_POLY_REG_CH", rb="com.motivewave.platform.study.nls.strings2", label="LBL_PRC", name="NAME_POLYNOMIAL_REGRESSION_CHANNEL", desc="DESC_POLY_REG_CH", helpLink="", signals=false, overlay=true, studyOverlay=true)
public class PolynomialRegCh
extends Study {
    static final String a = "stdDev1";
    static final String b = "stdDev2";
    static final String c = "path5";
    static final String d = "path6";
    static final String e = "path7";
    static final String f = "ind3";
    static final String g = "ind4";
    static final String h = "ind5";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("NUMBER_OF_POINTS", new Object[0]), 120, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("DEGREE", new Object[0]), 3, 1, 4, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("STD_DEV1", new Object[0]), 1.62, 0.0, 99.01, 0.01)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("STD_DEV2", new Object[0]), 2.0, 0.0, 99.01, 0.01)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PRC", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("HIGH_BAND1", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line3", this.get("LOW_BAND1", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line4", this.get("HIGH_BAND2", new Object[0]), defaults.getGreen(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(c, this.get("LOW_BAND2", new Object[0]), defaults.getGreen(), 1.0f, null, true, false, true)});
        settingTab = settingsDescriptor.addTab(this.get("DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("PRC_IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("HIGH_IND1", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(f, this.get("LOW_IND1", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(g, this.get("HIGH_IND2", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(h, this.get("LOW_IND2", new Object[0]), defaults.getGreen(), null, false, true, true)});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "line2", "line4", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "line3", c, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("NUMBER_OF_POINTS", new Object[0]), 120, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("DEGREE", new Object[0]), 3, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a, b, "line", "line2", "line3", "line4", c});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", a, b});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PolynomialRegCh$Values.PRC, this.get("PRC", new Object[0]), new String[]{"input", "period", "period2"}));
        runtimeDescriptor.declarePath((Object)PolynomialRegCh$Values.PRC, "line");
        runtimeDescriptor.declarePath((Object)PolynomialRegCh$Values.PRC_HIGH1, "line2");
        runtimeDescriptor.declarePath((Object)PolynomialRegCh$Values.PRC_LOW1, "line3");
        runtimeDescriptor.declarePath((Object)PolynomialRegCh$Values.PRC_HIGH2, "line4");
        runtimeDescriptor.declarePath((Object)PolynomialRegCh$Values.PRC_LOW2, c);
        runtimeDescriptor.declareIndicator((Object)PolynomialRegCh$Values.PRC, "ind");
        runtimeDescriptor.declareIndicator((Object)PolynomialRegCh$Values.PRC_HIGH1, "ind2");
        runtimeDescriptor.declareIndicator((Object)PolynomialRegCh$Values.PRC_LOW1, f);
        runtimeDescriptor.declareIndicator((Object)PolynomialRegCh$Values.PRC_HIGH2, g);
        runtimeDescriptor.declareIndicator((Object)PolynomialRegCh$Values.PRC_LOW2, h);
        runtimeDescriptor.setRangeKeys(new Object[]{PolynomialRegCh$Values.PRC, PolynomialRegCh$Values.PRC_HIGH2, PolynomialRegCh$Values.PRC_LOW2, PolynomialRegCh$Values.PRC_HIGH1, PolynomialRegCh$Values.PRC_LOW1});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 * n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        int n4;
        int n5;
        int n6 = this.getSettings().getInteger("period");
        int n7 = this.getSettings().getInteger("period2");
        if (n2 < n6) {
            return;
        }
        Enums.BarInput barInput = (Enums.BarInput)this.getSettings().getInput("input");
        Double d2 = this.getSettings().getDouble(a);
        Double d3 = this.getSettings().getDouble(b);
        DataSeries dataSeries = dataContext.getDataSeries();
        double[][] dArray = new double[10][10];
        double[] dArray2 = new double[10];
        double[] dArray3 = new double[10];
        double[] dArray4 = new double[10];
        Double d4 = 0.0;
        Double d5 = 0.0;
        Double d6 = 0.0;
        Double d7 = 0.0;
        Double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        int n8 = 0;
        int n9 = 0;
        dArray2[1] = n6 + 1;
        n9 = n7 + 1;
        for (n5 = 1; n5 <= n9 * 2 - 2; ++n5) {
            d9 = 0.0;
            for (n4 = 0; n4 <= n6; ++n4) {
                d9 += Math.pow(n4, n5);
            }
            dArray2[n5 + 1] = d9;
        }
        for (n5 = 1; n5 <= n9; ++n5) {
            d9 = 0.0;
            for (n4 = 0; n4 <= n6; ++n4) {
                if (n5 == 1) {
                    d9 += dataSeries.getDouble(n2 - n4, (Object)barInput, 0.0);
                    continue;
                }
                d9 += dataSeries.getDouble(n2 - n4, (Object)barInput, 0.0) * Math.pow(n4, n5 - 1);
            }
            dArray3[n5] = d9;
        }
        for (n5 = 1; n5 <= n9; ++n5) {
            for (n4 = 1; n4 <= n9; ++n4) {
                n8 = n4 + n5 - 1;
                dArray[n4][n5] = dArray2[n8];
            }
        }
        for (n8 = 1; n8 <= n9 - 1; ++n8) {
            int n10;
            n5 = 0;
            double d11 = 0.0;
            for (n10 = n8; n10 <= n9; ++n10) {
                if (!(Math.abs(dArray[n10][n8]) > d11)) continue;
                d11 = Math.abs(dArray[n10][n8]);
                n5 = n10;
            }
            if (n5 == 0) {
                return;
            }
            if (n5 != n8) {
                for (n10 = 1; n10 <= n9; ++n10) {
                    d10 = dArray[n8][n10];
                    dArray[n8][n10] = dArray[n5][n10];
                    dArray[n5][n10] = d10;
                }
                d10 = dArray3[n8];
                dArray3[n8] = dArray3[n5];
                dArray3[n5] = d10;
            }
            double d12 = 0.0;
            for (int i2 = n8 + 1; i2 <= n9; ++i2) {
                d12 = dArray[i2][n8] / dArray[n8][n8];
                for (int i3 = 1; i3 <= n9; ++i3) {
                    dArray[i2][i3] = i3 == n8 ? 0.0 : dArray[i2][i3] - d12 * dArray[n8][i3];
                }
                dArray3[i2] = dArray3[i2] - d12 * dArray3[n8];
            }
        }
        dArray4[n9] = dArray3[n9] / dArray[n9][n9];
        for (n5 = n9 - 1; n5 >= 1; --n5) {
            d10 = 0.0;
            for (int i4 = 1; i4 <= n9 - n5; ++i4) {
                dArray4[n5] = 1.0 / dArray[n5][n5] * (dArray3[n5] - (d10 += dArray[n5][n5 + i4] * dArray4[n5 + i4]));
            }
        }
        double d13 = 0.0;
        double d14 = 0.0;
        for (n3 = 0; n3 <= n6; ++n3) {
            d9 = 0.0;
            for (n8 = 1; n8 <= n7; ++n8) {
                d9 += dArray4[n8 + 1] * Math.pow(n3, n8);
            }
            d8 = dArray4[1] + d9;
            dataSeries.setDouble(n2 - n3, (Object)PolynomialRegCh$Values.PRC, d8);
            d13 += Math.pow(dataSeries.getDouble(n2 - n3, (Object)barInput, 0.0) - d8, 2.0);
            d14 += Math.pow(dataSeries.getDouble(n2 - n3, (Object)barInput, 0.0) - d8, 2.0);
        }
        d13 = Math.sqrt(d13 / (double)(n6 + 1)) * d2;
        d14 = Math.sqrt(d14 / (double)(n6 + 1)) * d3;
        for (n3 = 0; n3 <= n6; ++n3) {
            d4 = dataSeries.getDouble(n2 - n3, (Object)PolynomialRegCh$Values.PRC, 0.0) + d13;
            d5 = dataSeries.getDouble(n2 - n3, (Object)PolynomialRegCh$Values.PRC, 0.0) - d13;
            d6 = dataSeries.getDouble(n2 - n3, (Object)PolynomialRegCh$Values.PRC, 0.0) + d14;
            d7 = dataSeries.getDouble(n2 - n3, (Object)PolynomialRegCh$Values.PRC, 0.0) - d14;
            dataSeries.setDouble(n2 - n3, (Object)PolynomialRegCh$Values.PRC_HIGH1, d4);
            dataSeries.setDouble(n2 - n3, (Object)PolynomialRegCh$Values.PRC_LOW1, d5);
            dataSeries.setDouble(n2 - n3, (Object)PolynomialRegCh$Values.PRC_HIGH2, d6);
            dataSeries.setDouble(n2 - n3, (Object)PolynomialRegCh$Values.PRC_LOW2, d7);
        }
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

