/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.PolarizedFractalEfficiency$Signals;
import com.motivewave.platform.study.general.PolarizedFractalEfficiency$Values;

@StudyHeader(namespace="com.motivewave", id="ID_PLFE", rb="com.motivewave.platform.study.nls.strings2", name="NAME_POLARIZED_FRACTAL_EFFICIENCY", label="LBL_PLFE", desc="DESC_PLFE", helpLink="http://www.motivewave.com/studies/polarized_fractal_efficiency.htm", signals=true, overlay=false, studyOverlay=true)
public class PolarizedFractalEfficiency
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 9, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_PLFE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), null, null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -50.1, 50.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), -50.0, -999.1, 0.0, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor3});
        SettingGroup settingGroup5 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 9, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PolarizedFractalEfficiency$Values.EMA, this.get("EMA", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PolarizedFractalEfficiency$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PolarizedFractalEfficiency$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declarePath((Object)PolarizedFractalEfficiency$Values.EMA, "line");
        runtimeDescriptor.declareIndicator((Object)PolarizedFractalEfficiency$Values.EMA, "ind");
        runtimeDescriptor.declareSignal((Object)PolarizedFractalEfficiency$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)PolarizedFractalEfficiency$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{PolarizedFractalEfficiency$Values.EMA});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3 + 1) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = 0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = dataSeries.getDouble(n2, object, 0.0);
        double d10 = dataSeries.getDouble(n2 - n3, object, 0.0);
        d2 = Math.sqrt(Math.pow(d9 - d10, 2.0) + 100.0);
        for (n4 = 1; n4 <= n3; ++n4) {
            d7 = dataSeries.getDouble(n2 - n4 - 1, object, 0.0);
            d8 = dataSeries.getDouble(n2 - n4, object, 0.0);
            d3 += Math.sqrt(Math.pow(d7 - d8, 2.0) + 1.0);
        }
        d4 = d9 - d10 > 0.0 ? (double)Math.round(d2 / d3 * 100.0) : Math.rint(-(d2 / d3) * 100.0);
        d6 = dataSeries.getDouble(n2 - 1, (Object)PolarizedFractalEfficiency$Values.EMA, d4);
        d5 = Math.rint(d4 * 0.333 + d6 * 0.667);
        dataSeries.setDouble(n2, (Object)PolarizedFractalEfficiency$Values.EMA, Double.valueOf(d5));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d11 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d12 = guideInfo2.getValue();
        d6 = dataSeries.getDouble(n2 - 1, (Object)PolarizedFractalEfficiency$Values.EMA, 0.0);
        boolean bl2 = d5 > d11 && d6 >= d5 && d5 > this.a;
        boolean bl3 = d5 < d12 && d6 <= d5 && d5 < this.b;
        dataSeries.setBoolean(n2, (Object)PolarizedFractalEfficiency$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)PolarizedFractalEfficiency$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d5;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d5);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_PLFE", new Object[]{Util.round((double)d9, (int)2), Util.round((double)d5, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)PolarizedFractalEfficiency$Signals.SELL, string, (Object)d9);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d5;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d5);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_PLFE", new Object[]{Util.round((double)d9, (int)2), Util.round((double)d5, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)PolarizedFractalEfficiency$Signals.BUY, string, (Object)d9);
        }
        dataSeries.setComplete(n2);
    }
}

