/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.OSMA$Values;

@StudyHeader(namespace="com.motivewave", id="OSMA", rb="com.motivewave.platform.study.nls.strings", name="TITLE_OSMA", label="LBL_OSMA", desc="DESC_OSMA", menu="MENU_GENERAL", overlay=false, helpLink="http://www.motivewave.com/studies/moving_average_of_oscillator.htm")
public class OSMA
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("signalMethod", this.get("LBL_SIGNAL_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD1", new Object[0]), 12, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LBL_PERIOD2", new Object[0]), 26, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("signalPeriod", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 9, 1, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_SETTINGS", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("bar", this.get("LBL_BAR_COLOR", new Object[0]), defaults.getBarColor(), 1.0f, null, true, false, true);
        pathDescriptor.setShowAsBars(true);
        pathDescriptor.setSupportsShowAsBars(true);
        pathDescriptor.setColorPolicies(Enums.ColorPolicy.values());
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), defaults.getBarColor(), null, false, false, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method", "signalMethod"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD1", new Object[0]), 12, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("LBL_PERIOD2", new Object[0]), 26, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("signalPeriod", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 9, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"bar"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"period", "period2", "signalPeriod"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)OSMA$Values.OSMA, this.get("LBL_OSMA", new Object[0]), new String[]{"period", "period2", "signalPeriod"}));
        runtimeDescriptor.declarePath((Object)OSMA$Values.OSMA, "bar");
        runtimeDescriptor.declareIndicator((Object)OSMA$Values.OSMA, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{OSMA$Values.OSMA});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        int n4 = this.getSettings().getInteger("period", 12);
        int n5 = Util.max((int)n4, (int)(n3 = this.getSettings().getInteger("period2", 26)));
        if (n2 <= n5) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        Enums.MAMethod mAMethod2 = this.getSettings().getMAMethod("signalMethod", Enums.MAMethod.SMA);
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = null;
        Double d3 = null;
        d2 = dataSeries.ma(mAMethod, n2, n4, object);
        d3 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d2 == null || d3 == null) {
            return;
        }
        double d4 = d2 - d3;
        dataSeries.setDouble(n2, (Object)OSMA$Values.MACD, Double.valueOf(d4));
        int n6 = this.getSettings().getInteger("signalPeriod", 9);
        if (n2 <= n5 + n6) {
            return;
        }
        Double d5 = dataSeries.ma(mAMethod2, n2, n6, (Object)OSMA$Values.MACD);
        dataSeries.setDouble(n2, (Object)OSMA$Values.SIGNAL, d5);
        if (d5 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)OSMA$Values.OSMA, Double.valueOf(d4 - d5));
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

