/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.FontInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.PathInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.X11Colors;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.FontDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Label;
import com.motivewave.platform.sdk.draw.Line;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.NetLines$Signals;
import com.motivewave.platform.study.general.NetLines$Values;
import java.awt.Color;
import java.awt.Font;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="NET_LINES", rb="com.motivewave.platform.study.nls.strings2", name="NAME_NET_LINES", desc="DESC_NET_LINES", label="LBL_NL", helpLink="", overlay=true)
public class NetLines
extends Study {
    static final String a = "showLabel";
    static final String b = "showPrice";
    static final String c = "timeOut";
    int a = 3;
    int b = 3;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("HIGH_INPUT", new Object[0]), (Object)Enums.BarInput.HIGH)});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input2", this.get("LOW_INPUT", new Object[0]), (Object)Enums.BarInput.LOW)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(c, this.get("TIME_OUT", new Object[0]), 3, 1, 99, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new FontDescriptor("font", this.get("FONT", new Object[0]), defaults.getFont())});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(a, this.get("SHOW_LABELS", new Object[0]), Boolean.valueOf(false))});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(b, this.get("SHOW_PRICES", new Object[0]), Boolean.valueOf(false))});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("HIGHER_PRICES", new Object[0]), defaults.getGreen(), 1.0f, null, true, false, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("LOWER_PRICES", new Object[0]), defaults.getRed(), 1.0f, null, true, false, false)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("BUY_MARKER", new Object[0]), Enums.MarkerType.LINE_ARROW, Enums.Size.VERY_LARGE, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("SELL_MARKER", new Object[0]), Enums.MarkerType.LINE_ARROW, Enums.Size.VERY_LARGE, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "input2", c, "line", "line2"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)NetLines$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)NetLines$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)NetLines$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)NetLines$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setLabelSettings(new String[]{"input", "input2", c});
        runtimeDescriptor.setRangeKeys(new Object[]{NetLines$Values.BUY_PIVOT, NetLines$Values.SELL_PIVOT});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger(c);
        this.setMinBars(n2 * 10);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        Coordinate coordinate;
        Coordinate coordinate2;
        int n3;
        Line line;
        Coordinate coordinate3;
        Coordinate coordinate4;
        boolean bl2 = this.getSettings().is(a);
        boolean bl3 = this.getSettings().is(b);
        int n4 = this.getSettings().getInteger(c);
        DataSeries dataSeries = dataContext.getDataSeries();
        if (n2 < n4 + 3) {
            return;
        }
        Object object = this.getSettings().getInput("input");
        Object object2 = this.getSettings().getInput("input2");
        PathInfo pathInfo = this.getSettings().getPath("line");
        Color color = pathInfo.getColor();
        PathInfo pathInfo2 = this.getSettings().getPath("line2");
        Color color2 = pathInfo2.getColor();
        FontInfo fontInfo = this.getSettings().getFont("font");
        Font font = fontInfo.getFont();
        MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
        MarkerInfo markerInfo2 = this.getSettings().getMarker("upMarker");
        double d2 = dataSeries.getInstrument().getTickSize() * 10.0;
        int n5 = (int)Math.log10(1.0 / d2) + 1;
        this.b = 3;
        this.a = 3;
        int n6 = this.a(n2, dataSeries, object);
        int n7 = this.b(n2, dataSeries, object2);
        double d3 = dataSeries.getLow(n6);
        double d4 = dataSeries.getHigh(n7);
        int n8 = n4 + this.a - 1;
        int n9 = n4 + this.b - 1;
        if (n6 != -1) {
            coordinate4 = new Coordinate(dataSeries.getStartTime(n6), d3);
            coordinate3 = new Coordinate(dataSeries.getStartTime(n6 + n8), d3);
            line = new Line(coordinate4, coordinate3, pathInfo2);
            if (bl3) {
                line.setText(Double.toString(Util.round((double)d3, (int)n5)), font);
            }
            this.addFigure((Figure)line);
            for (n3 = n6; n3 <= n6 + n8; ++n3) {
                dataSeries.setDouble(n3, (Object)NetLines$Values.BUY_PIVOT, Double.valueOf(d3));
            }
            if (bl2) {
                Label label = new Label(this.get("SP", new Object[0]), font, X11Colors.BLACK, color2);
                coordinate2 = new Coordinate(dataSeries.getStartTime(n6), d3);
                label.setLocation(coordinate2);
                this.addFigure((Figure)label);
            }
        }
        if (n7 != -1) {
            coordinate4 = new Coordinate(dataSeries.getStartTime(n7), d4);
            coordinate3 = new Coordinate(dataSeries.getStartTime(n7 + n9), d4);
            line = new Line(coordinate4, coordinate3, pathInfo);
            if (bl3) {
                line.setText(Double.toString(Util.round((double)d4, (int)n5)), font);
            }
            this.addFigure((Figure)line);
            for (n3 = n7; n3 <= n7 + n9; ++n3) {
                dataSeries.setDouble(n3, (Object)NetLines$Values.SELL_PIVOT, Double.valueOf(d4));
            }
            if (bl2) {
                Label label = new Label(this.get("BP", new Object[0]), font, X11Colors.BLACK, color);
                coordinate2 = new Coordinate(dataSeries.getStartTime(n7), d4);
                label.setLocation(coordinate2);
                this.addFigure((Figure)label);
            }
        }
        double d5 = dataSeries.getDouble(n2, (Object)NetLines$Values.SELL_PIVOT, Double.MAX_VALUE);
        double d6 = dataSeries.getDouble(n2, (Object)NetLines$Values.BUY_PIVOT, 0.0);
        double d7 = dataSeries.getHigh(n2);
        double d8 = dataSeries.getLow(n2);
        boolean bl4 = d7 > d5;
        boolean bl5 = d8 < d6;
        dataSeries.setBoolean((Object)NetLines$Signals.BUY, Boolean.valueOf(bl5));
        dataSeries.setBoolean((Object)NetLines$Signals.SELL, Boolean.valueOf(bl4));
        long l2 = dataSeries.getStartTime(n2);
        if (bl4) {
            coordinate = new Coordinate(l2, d5);
            string = this.get("SELL_PRICE", new Object[]{Util.round((double)d5, (int)n5)});
            if (markerInfo2.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)NetLines$Signals.SELL, string, (Object)d7);
        }
        if (bl5) {
            coordinate = new Coordinate(l2, d6);
            string = this.get("BUY_PRICE", new Object[]{Util.round((double)d6, (int)n5)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo2, string));
            }
            dataContext.signal(n2, (Object)NetLines$Signals.BUY, string, (Object)d8);
        }
        if (dataSeries.isBarComplete(n2)) {
            dataSeries.setComplete(n2);
        }
    }

    private int a(int n2, DataSeries dataSeries, Object object) {
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = dataSeries.getHigh(n2);
        double d4 = dataSeries.getLow(n2);
        int n3 = 0;
        this.a = 3;
        for (n3 = n2 - 1; n3 > n2 - this.a; --n3) {
            if (n3 < 0) {
                return -1;
            }
            double d5 = dataSeries.getHigh(n3);
            double d6 = dataSeries.getLow(n3);
            if (d5 < d3 && d6 > d4) {
                ++this.a;
                continue;
            }
            d3 = d5;
            d4 = d6;
            double d7 = dataSeries.getDouble(n3, object, 0.0);
            if (d7 >= d2) {
                return -1;
            }
            d2 = d7;
        }
        return n3 + 1;
    }

    private int b(int n2, DataSeries dataSeries, Object object) {
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = dataSeries.getHigh(n2);
        double d4 = dataSeries.getLow(n2);
        int n3 = 0;
        this.b = 3;
        for (n3 = n2 - 1; n3 > n2 - this.b; --n3) {
            if (n3 < 0) {
                return -1;
            }
            double d5 = dataSeries.getHigh(n3);
            double d6 = dataSeries.getLow(n3);
            if (d5 < d3 && d6 > d4) {
                ++this.b;
                continue;
            }
            d3 = d5;
            d4 = d6;
            double d7 = dataSeries.getDouble(n3, object, 0.0);
            if (d7 <= d2) {
                return -1;
            }
            d2 = d7;
        }
        return n3 + 1;
    }
}

