/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.MovAvgAdpFilter$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ID_MAAF", rb="com.motivewave.platform.study.nls.strings2", name="NAME_MOVING_AVG_ADAPTIVE_FILTER", label="LBL_MAAF", desc="DESC_MAAF", helpLink="http://www.motivewave.com/studies/moving_avg_adaptive_filter.htm", requiresVolume=false, signals=true, overlay=false, studyOverlay=true)
public class MovAvgAdpFilter
extends Study {
    static final String a = "Filter";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 10, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("FILTER", new Object[0]), 0.15, 0.0, 9.01, 0.01)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, 0.0, 2.001, 0.001, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a, "upColor", "downColor"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MovAvgAdpFilter$Values.AMAF, this.get("LBL_MAAF", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.declareBars((Object)MovAvgAdpFilter$Values.AMAF);
        runtimeDescriptor.declareIndicator((Object)MovAvgAdpFilter$Values.AMAF, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{MovAvgAdpFilter$Values.AMAF});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 * 2 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < 1) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        double d2 = this.getSettings().getDouble(a);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = 0.6667;
        double d4 = 0.0645;
        double d5 = dataSeries.getDouble(n2, object, 0.0);
        double d6 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d7 = Math.abs(d5 - d6);
        dataSeries.setDouble(n2, (Object)MovAvgAdpFilter$Values.DIFF, Double.valueOf(d7));
        if (n2 < n3 + 1) {
            return;
        }
        double d8 = dataSeries.getDouble(n2 - n3, object, d5);
        double d9 = Math.abs(d5 - d8);
        double d10 = dataSeries.sum(n2, n3, (Object)MovAvgAdpFilter$Values.DIFF);
        if (d10 == 0.0) {
            return;
        }
        double d11 = d9 / d10;
        double d12 = Math.pow(d11 * (d3 - d4) + d4, 2.0);
        double d13 = dataSeries.getDouble(n2 - 1, (Object)MovAvgAdpFilter$Values.AMA, d5);
        double d14 = d13 + d12 * (d5 - d13);
        dataSeries.setDouble(n2, (Object)MovAvgAdpFilter$Values.AMA, Double.valueOf(d14));
        double d15 = d14 - d13;
        dataSeries.setDouble(n2, (Object)MovAvgAdpFilter$Values.AMA_DIFF, Double.valueOf(d15));
        if (n2 < n3 * 2 + 1) {
            return;
        }
        double d16 = dataSeries.std(n2, n3, (Object)MovAvgAdpFilter$Values.AMA_DIFF) * d2;
        dataSeries.setDouble(n2, (Object)MovAvgAdpFilter$Values.AMAF, Double.valueOf(d16));
        GuideInfo guideInfo = this.getSettings().getGuide("middleGuide");
        double d17 = guideInfo.getValue();
        Color color = this.getSettings().getColor("upColor");
        Color color2 = this.getSettings().getColor("downColor");
        if (d16 > d17) {
            dataSeries.setBarColor(n2, (Object)MovAvgAdpFilter$Values.AMAF, color);
        } else {
            dataSeries.setBarColor(n2, (Object)MovAvgAdpFilter$Values.AMAF, color2);
        }
        dataSeries.setComplete(n2);
    }
}

