/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.MFI$Signals;
import com.motivewave.platform.study.general.MFI$Values;

@StudyHeader(namespace="com.motivewave", id="MFI", rb="com.motivewave.platform.study.nls.strings", name="TITLE_MFI", tabName="TAB_MFI", desc="DESC_MFI", menu="MENU_GENERAL", overlay=false, requiresVolume=true, signals=true, helpLink="http://www.motivewave.com/studies/money_flow_index.htm")
public class MFI
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, 1)});
        settingGroup = settingTab.addGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null)});
        settingGroup.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "topGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "bottomGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_ADVANCED", new Object[0]));
        settingGroup = settingTab.addGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 80.0, 0.0, 100.0, 1.0, true)});
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("LBL_MIDDLE_GUIDE", new Object[0]), 50.0, 1.0, 100.0, 1.0, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), 20.0, 0.0, 100.0, 1.0, true)});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MFI$Values.MFI, this.get("TAB_MFI", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declarePath((Object)MFI$Values.MFI, "line");
        runtimeDescriptor.declareIndicator((Object)MFI$Values.MFI, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{MFI$Values.MFI});
        runtimeDescriptor.setMaxBottomValue(Integer.valueOf(10));
        runtimeDescriptor.setMinTopValue(Integer.valueOf(90));
        runtimeDescriptor.setMinTick(Double.valueOf(0.1));
        runtimeDescriptor.declareSignal((Object)MFI$Signals.MFI_TOP, this.get("LBL_MFI_TOP", new Object[0]));
        runtimeDescriptor.declareSignal((Object)MFI$Signals.MFI_BOTTOM, this.get("LBL_MFI_BOTTOM", new Object[0]));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = dataSeries.getTypicalPrice(n2 - n3).floatValue();
        for (int i2 = n2 - n3 + 1; i2 <= n2; ++i2) {
            double d5 = dataSeries.getTypicalPrice(i2).floatValue();
            double d6 = d5 * (double)dataSeries.getVolume(i2);
            if (d5 > d4) {
                d2 += d6;
            } else {
                d3 += d6;
            }
            d4 = d5;
        }
        double d7 = 100.0 * (d2 / (d2 + d3));
        dataSeries.setDouble(n2, (Object)MFI$Values.MFI, Double.valueOf(d7));
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        d7 = this.round(d7);
        if (this.crossedAbove(dataSeries, n2, (Object)MFI$Values.MFI, guideInfo.getValue())) {
            dataContext.signal(n2, (Object)MFI$Signals.MFI_TOP, this.get("SIGNAL_MFI_TOP", new Object[]{d7, guideInfo.getValue()}), (Object)d7);
        } else if (this.crossedBelow(dataSeries, n2, (Object)MFI$Values.MFI, guideInfo2.getValue())) {
            dataContext.signal(n2, (Object)MFI$Signals.MFI_BOTTOM, this.get("SIGNAL_MFI_BOTTOM", new Object[]{d7, guideInfo2.getValue()}), (Object)d7);
        }
        dataSeries.setComplete(n2);
    }
}

