/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.InstrumentDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.MCSumIndex$Values;

@StudyHeader(namespace="com.motivewave", id="MC_SUM_IND", rb="com.motivewave.platform.study.nls.strings", name="TITLE_MC_SUM_IND", label="NAME_MC_SUM_IND", desc="DESC_MC_SUM_IND", menu="MENU_GENERAL", overlay=false, multipleInstrument=true)
public class MCSumIndex
extends Study {
    static final String a = "adv";
    static final String b = "dec";
    static final String c = "radj";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InstrumentDescriptor(a, this.get("LBL_MC_ADVANCING", new Object[0]))});
        settingGroup.addRow(new SettingDescriptor[]{new InstrumentDescriptor(b, this.get("LBL_MC_DECLINING", new Object[0]))});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(c, this.get("LBL_MC_RATIO_ADJUSTED", new Object[0]), Boolean.valueOf(true))});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("fastPeriod", this.get("LBL_MC_FAST_PERIOD", new Object[0]), 19, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("slowPeriod", this.get("LBL_MC_SLOW_PERIOD", new Object[0]), 39, 1, 999, 1)});
        settingGroup = settingTab.addGroup(this.get("LBL_DISPLAY", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{a, b, "input", c});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("fastPeriod", this.get("LBL_MC_FAST_PERIOD", new Object[0]), 19, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("slowPeriod", this.get("LBL_MC_SLOW_PERIOD", new Object[0]), 39, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{a, b});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MCSumIndex$Values.MC_OSC, this.get("LBL_MC_OSC", new Object[0]), new String[]{"fastPeriod", "slowPeriod"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MCSumIndex$Values.SUM, this.get("LBL_MC_SUM", new Object[0]), new String[0]));
        runtimeDescriptor.declarePath((Object)MCSumIndex$Values.SUM, "line");
        runtimeDescriptor.declareIndicator((Object)MCSumIndex$Values.SUM, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{MCSumIndex$Values.SUM});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        runtimeDescriptor.setMinTick(Double.valueOf(1.0));
    }

    protected void calculate(int n2, DataContext dataContext) {
        Instrument instrument = this.getSettings().getInstrument(a);
        Instrument instrument2 = this.getSettings().getInstrument(b);
        DataSeries dataSeries = dataContext.getDataSeries();
        if (dataSeries == null || instrument == null || instrument2 == null) {
            return;
        }
        Enums.BarInput barInput = (Enums.BarInput)this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Double d2 = dataSeries.getDouble(n2, barInput, instrument);
        Double d3 = dataSeries.getDouble(n2, barInput, instrument2);
        if (d2 == null || d3 == null) {
            return;
        }
        double d4 = instrument.round(d2 - d3);
        if (this.getSettings().is(c)) {
            d4 = 1000.0 * d4 / (d2 + d3);
        }
        dataSeries.setDouble(n2, (Object)MCSumIndex$Values.NET, Double.valueOf(d4));
        int n3 = this.getSettings().getInteger("fastPeriod", 19);
        if (n2 > n3) {
            dataSeries.setDouble(n2, (Object)MCSumIndex$Values.FAST, dataSeries.ema(n2, n3, (Object)MCSumIndex$Values.NET));
        }
        int n4 = this.getSettings().getInteger("slowPeriod", 39);
        if (n2 > n3) {
            dataSeries.setDouble(n2, (Object)MCSumIndex$Values.SLOW, dataSeries.ema(n2, n4, (Object)MCSumIndex$Values.NET));
        }
        Double d5 = dataSeries.getDouble(n2, (Object)MCSumIndex$Values.FAST);
        Double d6 = dataSeries.getDouble(n2, (Object)MCSumIndex$Values.SLOW);
        if (d5 == null || d6 == null) {
            return;
        }
        double d7 = d5 - d6;
        dataSeries.setDouble(n2, (Object)MCSumIndex$Values.MC_OSC, Double.valueOf(d7));
        double d8 = dataSeries.getDouble(n2 - 1, (Object)MCSumIndex$Values.SUM, 0.0);
        dataSeries.setDouble(n2, (Object)MCSumIndex$Values.SUM, Double.valueOf(d8 + d7));
        dataSeries.setComplete(n2, n2 < dataSeries.size() - 1);
    }
}

