/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.InstrumentDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.MCOscillator$Signals;
import com.motivewave.platform.study.general.MCOscillator$Values;

@StudyHeader(namespace="com.motivewave", id="MC_OSC", rb="com.motivewave.platform.study.nls.strings", name="TITLE_MC_OSC", desc="DESC_MC_OSC", menu="MENU_GENERAL", overlay=false, signals=true, label="NAME_MC_OSC", multipleInstrument=true)
public class MCOscillator
extends Study {
    static final String a = "adv";
    static final String b = "dec";
    static final String c = "slowPath";
    static final String d = "fastPath";
    static final String e = "slowInd";
    static final String f = "fastInd";
    static final String g = "histInd";
    static final String h = "radj";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InstrumentDescriptor(a, this.get("LBL_MC_ADVANCING", new Object[0]))});
        settingGroup.addRow(new SettingDescriptor[]{new InstrumentDescriptor(b, this.get("LBL_MC_DECLINING", new Object[0]))});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(h, this.get("LBL_MC_RATIO_ADJUSTED", new Object[0]), Boolean.valueOf(true))});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("fastPeriod", this.get("LBL_MC_FAST_PERIOD", new Object[0]), 19, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("slowPeriod", this.get("LBL_MC_SLOW_PERIOD", new Object[0]), 39, 1, 999, 1)});
        settingGroup = settingTab.addGroup(this.get("LBL_DISPLAY", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor(d, this.get("LBL_MC_FAST_MA", new Object[0]), defaults.getRedLine(), 1.0f, null)});
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor(c, this.get("LBL_MC_SLOW_MA", new Object[0]), defaults.getBlueLine(), 1.0f, null)});
        PathDescriptor pathDescriptor = new PathDescriptor("bar", this.get("LBL_HISTOGRAM", new Object[0]), defaults.getBarColor(), 1.0f, null, true, false, true);
        pathDescriptor.setShowAsBars(true);
        pathDescriptor.setSupportsShowAsBars(true);
        pathDescriptor.setColorPolicies(Enums.ColorPolicy.values());
        settingGroup.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_ADVANCED", new Object[0]));
        settingGroup = settingTab.addGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(e, this.get("LBL_MC_SLOW_IND", new Object[0]), null, null, false, true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(f, this.get("LBL_MC_FAST_IND", new Object[0]), defaults.getRed(), null, false, false, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor(g, this.get("LBL_MC_HIST_IND", new Object[0]), defaults.getBarColor(), null, false, false, true)});
        settingsDescriptor.addQuickSettings(new String[]{a, b, "input", h});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("fastPeriod", this.get("LBL_MC_FAST_PERIOD", new Object[0]), 19, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("slowPeriod", this.get("LBL_MC_SLOW_PERIOD", new Object[0]), 39, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{d, c});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{a, b, "input", "fastPeriod", "slowPeriod"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MCOscillator$Values.FAST, this.get("LBL_MC_FAST_MA", new Object[0]), new String[]{"fastPeriod"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MCOscillator$Values.SLOW, this.get("LBL_MC_SLOW_MA", new Object[0]), new String[]{"slowPeriod"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MCOscillator$Values.HIST, this.get("LBL_MC_HIST", new Object[0]), new String[]{"fastPeriod", "slowPeriod"}));
        runtimeDescriptor.declarePath((Object)MCOscillator$Values.SLOW, c);
        runtimeDescriptor.declarePath((Object)MCOscillator$Values.FAST, d);
        runtimeDescriptor.declarePath((Object)MCOscillator$Values.HIST, "bar");
        runtimeDescriptor.declareIndicator((Object)MCOscillator$Values.SLOW, e);
        runtimeDescriptor.declareIndicator((Object)MCOscillator$Values.FAST, f);
        runtimeDescriptor.declareIndicator((Object)MCOscillator$Values.HIST, g);
        runtimeDescriptor.declareSignal((Object)MCOscillator$Signals.CROSS_ABOVE, this.get("LBL_CROSS_ABOVE_SIGNAL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)MCOscillator$Signals.CROSS_BELOW, this.get("LBL_CROSS_BELOW_SIGNAL", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{MCOscillator$Values.SLOW, MCOscillator$Values.FAST, MCOscillator$Values.HIST});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        runtimeDescriptor.setMinTick(Double.valueOf(0.01));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        Instrument instrument = this.getSettings().getInstrument(a);
        Instrument instrument2 = this.getSettings().getInstrument(b);
        DataSeries dataSeries = dataContext.getDataSeries();
        if (dataSeries == null || instrument == null || instrument2 == null) {
            return;
        }
        Enums.BarInput barInput = (Enums.BarInput)this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Double d2 = dataSeries.getDouble(n2, barInput, instrument);
        Double d3 = dataSeries.getDouble(n2, barInput, instrument2);
        if (d2 == null || d3 == null) {
            return;
        }
        double d4 = instrument.round(d2 - d3);
        if (this.getSettings().is(h)) {
            d4 = 1000.0 * d4 / (d2 + d3);
        }
        dataSeries.setDouble(n2, (Object)MCOscillator$Values.NET_ADV, Double.valueOf(d4));
        int n4 = this.getSettings().getInteger("fastPeriod", 19);
        if (n2 > n4) {
            dataSeries.setDouble(n2, (Object)MCOscillator$Values.FAST, dataSeries.ema(n2, n4, (Object)MCOscillator$Values.NET_ADV));
        }
        if (n2 > (n3 = this.getSettings().getInteger("slowPeriod", 39))) {
            dataSeries.setDouble(n2, (Object)MCOscillator$Values.SLOW, dataSeries.ema(n2, n3, (Object)MCOscillator$Values.NET_ADV));
        }
        Double d5 = dataSeries.getDouble(n2, (Object)MCOscillator$Values.FAST);
        Double d6 = dataSeries.getDouble(n2, (Object)MCOscillator$Values.SLOW);
        if (d5 == null || d6 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)MCOscillator$Values.HIST, Double.valueOf(d5 - d6));
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d6.doubleValue());
        if (this.crossedAbove(dataSeries, n2, (Object)MCOscillator$Values.FAST, (Object)MCOscillator$Values.SLOW)) {
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("SIGNAL_MC_CROSS_ABOVE", new Object[]{d5, d6});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)MCOscillator$Signals.CROSS_ABOVE, string, (Object)d6);
        } else if (this.crossedBelow(dataSeries, n2, (Object)MCOscillator$Values.FAST, (Object)MCOscillator$Values.SLOW)) {
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("SIGNAL_MC_CROSS_BELOW", new Object[]{d5, d6});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)MCOscillator$Signals.CROSS_BELOW, string, (Object)d6);
        }
        dataSeries.setComplete(n2);
    }
}

