/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BarDescriptor;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.MADifference$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="MA_DIFF", rb="com.motivewave.platform.study.nls.strings", name="TITLE_MA_DIFF", label="LBL_MA_DIFF", desc="DESC_MA_DIFF", menu="MENU_GENERAL", overlay=false, helpLink="http://www.motivewave.com/studies/ma_difference.htm")
public class MADifference
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_MA1_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_MA1_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_MA1_PERIOD", new Object[0]), 10, 1, 9999, 1), new IntegerDescriptor("shift", this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input2", this.get("LBL_MA2_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method2", this.get("LBL_MA2_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LBL_MA2_PERIOD", new Object[0]), 5, 1, 9999, 1), new IntegerDescriptor("shift2", this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new BarDescriptor("bar", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreen(), true, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_MA1_PERIOD", new Object[0]), 21, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("shift", this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, true, () -> Enums.Icon.SHIFT.get())});
        settingsDescriptor.addQuickSettings(new String[]{"input2", "method2"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("LBL_MA2_PERIOD", new Object[0]), 5, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("shift2", this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, true, () -> Enums.Icon.SHIFT.get())});
        settingsDescriptor.addQuickSettings(new String[]{"bar", "downColor"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "input2", "method2", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MADifference$Values.DIFF, this.get("LBL_MA_DIFF", new Object[0]), new String[]{"input", "method", "period", "input2", "method2", "period2"}));
        runtimeDescriptor.declareBars((Object)MADifference$Values.DIFF, "bar");
        runtimeDescriptor.declareIndicator((Object)MADifference$Values.DIFF, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{MADifference$Values.DIFF});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        int n4 = this.getSettings().getInteger("period", 10);
        int n5 = this.getSettings().getInteger("period2", 5);
        int n6 = this.getSettings().getInteger("shift", 0);
        if (n2 <= Util.max((int)(n4 - n6), (int)(n5 - (n3 = this.getSettings().getInteger("shift2", 0))))) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.SMA);
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod2 = this.getSettings().getMAMethod("method2", Enums.MAMethod.SMA);
        Object object2 = this.getSettings().getInput("input2", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.ma(mAMethod, n2 + n6, n4, object);
        Double d3 = dataSeries.ma(mAMethod2, n2 + n3, n5, object2);
        if (d2 == null || d3 == null) {
            return;
        }
        Color color = this.getSettings().getBars("bar").getColor();
        Color color2 = this.getSettings().getColor("downColor");
        double d4 = d2 - d3;
        dataSeries.setDouble(n2, (Object)MADifference$Values.DIFF, Double.valueOf(d4));
        dataSeries.setBarColor(n2, (Object)MADifference$Values.DIFF, d4 >= 0.0 ? color : color2);
        dataSeries.setComplete(n2);
    }
}

