/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Settings;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.MACD$Signals;
import com.motivewave.platform.study.general.MACD$Values;

@StudyHeader(namespace="com.motivewave", id="MACD", rb="com.motivewave.platform.study.nls.strings", name="TITLE_MACD", label="LBL_MACD", desc="DESC_MACD", menu="MENU_GENERAL", overlay=false, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/moving_average_convergence_divergence.htm")
public class MACD
extends Study {
    static final String a = "macdLine";
    static final String b = "macdInd";
    static final String c = "histInd";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        settingTab.add("", new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE), new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.EMA), new MAMethodDescriptor("signalMethod", this.get("LBL_SIGNAL_METHOD", new Object[0]), Enums.MAMethod.SMA), new IntegerDescriptor("period", this.get("LBL_PERIOD1", new Object[0]), 12, 1, 9999, 1), new IntegerDescriptor("period2", this.get("LBL_PERIOD2", new Object[0]), 26, 1, 9999, 1), new IntegerDescriptor("signalPeriod", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 9, 1, 9999, 1)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("bar", this.get("LBL_HISTOGRAM", new Object[0]), defaults.getBarColor(), 1.0f, null, true, false, true);
        pathDescriptor.setShowAsBars(true);
        pathDescriptor.setSupportsShowAsBars(true);
        pathDescriptor.setColorPolicies(Enums.ColorPolicy.values());
        settingTab.addGroup("", new SettingDescriptor[]{new PathDescriptor(a, this.get("LBL_MACD_LINE", new Object[0]), defaults.getLineColor(), 1.5f, null, true, false, true), new IndicatorDescriptor(b, this.get("LBL_MACD_IND", new Object[0]), null, null, false, true, true), new PathDescriptor("signalLine", this.get("LBL_SIGNAL_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true), new IndicatorDescriptor("signalInd", this.get("LBL_SIGNAL_IND", new Object[0]), defaults.getRed(), null, false, false, true), pathDescriptor, new IndicatorDescriptor(c, this.get("LBL_MACD_HIST_IND", new Object[0]), defaults.getBarColor(), null, false, false, true), new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), a, "signalLine", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), false, true), new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), a, "signalLine", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), false, true), new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), false, true), new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method", "signalMethod"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD1", new Object[0]), 12, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("LBL_PERIOD2", new Object[0]), 26, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("signalPeriod", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 9, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a, "signalLine", "bar"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2", "signalPeriod"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MACD$Values.MACD, this.get("LBL_MACD", new Object[0]), new String[]{"input", "method", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MACD$Values.SIGNAL, this.get("LBL_MACD_SIGNAL", new Object[0]), new String[]{"signalPeriod"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MACD$Values.HIST, this.get("LBL_MACD_HIST", new Object[0]), new String[]{"period", "period2", "signalPeriod"}));
        runtimeDescriptor.declarePath((Object)MACD$Values.MACD, a);
        runtimeDescriptor.declarePath((Object)MACD$Values.SIGNAL, "signalLine");
        runtimeDescriptor.declarePath((Object)MACD$Values.HIST, "bar");
        runtimeDescriptor.declareIndicator((Object)MACD$Values.MACD, b);
        runtimeDescriptor.declareIndicator((Object)MACD$Values.SIGNAL, "signalInd");
        runtimeDescriptor.declareIndicator((Object)MACD$Values.HIST, c);
        runtimeDescriptor.declareSignal((Object)MACD$Signals.CROSS_ABOVE, this.get("LBL_CROSS_ABOVE_SIGNAL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)MACD$Signals.CROSS_BELOW, this.get("LBL_CROSS_BELOW_SIGNAL", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{MACD$Values.MACD, MACD$Values.SIGNAL, MACD$Values.HIST});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        Settings settings = this.getSettings();
        int n4 = settings.getInteger("period");
        int n5 = Util.max((int)n4, (int)(n3 = settings.getInteger("period2").intValue()));
        if (n2 < n5) {
            return;
        }
        Enums.MAMethod mAMethod = settings.getMAMethod("method");
        Object object = settings.getInput("input");
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.ma(mAMethod, n2, n4, object);
        Double d3 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d2 == null || d3 == null) {
            return;
        }
        double d4 = d2 - d3;
        dataSeries.setDouble(n2, (Object)MACD$Values.MACD, Double.valueOf(d4));
        int n6 = settings.getInteger("signalPeriod");
        if (n2 < n5 + n6) {
            return;
        }
        Double d5 = dataSeries.ma(this.getSettings().getMAMethod("signalMethod", Enums.MAMethod.SMA), n2, n6, (Object)MACD$Values.MACD);
        if (d5 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)MACD$Values.SIGNAL, d5);
        dataSeries.setDouble(n2, (Object)MACD$Values.HIST, Double.valueOf(d4 - d5));
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d5.doubleValue());
        if (this.crossedAbove(dataSeries, n2, (Object)MACD$Values.MACD, (Object)MACD$Values.SIGNAL)) {
            MarkerInfo markerInfo = settings.getMarker("upMarker");
            String string = this.get("SIGNAL_MACD_CROSS_ABOVE", new Object[]{d4, d5});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)MACD$Signals.CROSS_ABOVE, string, (Object)d5);
        } else if (this.crossedBelow(dataSeries, n2, (Object)MACD$Values.MACD, (Object)MACD$Values.SIGNAL)) {
            MarkerInfo markerInfo = settings.getMarker("downMarker");
            String string = this.get("SIGNAL_MACD_CROSS_BELOW", new Object[]{d4, d5});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)MACD$Signals.CROSS_BELOW, string, (Object)d5);
        }
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

