/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.KST$Signals;
import com.motivewave.platform.study.general.KST$Values;

@StudyHeader(namespace="com.motivewave", id="KST", rb="com.motivewave.platform.study.nls.strings", name="TITLE_KST", label="LBL_KST", desc="DESC_KST", menu="MENU_GENERAL", overlay=false, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/know_sure_thing.htm")
public class KST
extends Study {
    static final String a = "ma1";
    static final String b = "ma2";
    static final String c = "ma3";
    static final String d = "ma4";
    static final String e = "r1";
    static final String f = "r2";
    static final String g = "r3";
    static final String h = "r4";
    static final String i = "w1";
    static final String j = "w2";
    static final String k = "w3";
    static final String l = "w4";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_KST_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("signalMethod", this.get("LBL_SIGNAL_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("signalPeriod", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 8, 1, 9999, 1)});
        settingGroup = settingTab.addGroup(this.get("LBL_ROC", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_MA1", new Object[0]), 10, 1, 9999, 1), new IntegerDescriptor(e, this.get("LBL_R1", new Object[0]), 10, 0, 9999, 1), new IntegerDescriptor(i, this.get("LBL_W1", new Object[0]), 1, 0, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b, this.get("LBL_MA2", new Object[0]), 10, 1, 9999, 1), new IntegerDescriptor(f, this.get("LBL_R2", new Object[0]), 15, 0, 9999, 1), new IntegerDescriptor(j, this.get("LBL_W2", new Object[0]), 2, 0, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(c, this.get("LBL_MA3", new Object[0]), 10, 1, 9999, 1), new IntegerDescriptor(g, this.get("LBL_R3", new Object[0]), 20, 0, 9999, 1), new IntegerDescriptor(k, this.get("LBL_W3", new Object[0]), 3, 0, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(d, this.get("LBL_MA4", new Object[0]), 15, 1, 9999, 1), new IntegerDescriptor(h, this.get("LBL_R4", new Object[0]), 30, 0, 9999, 1), new IntegerDescriptor(l, this.get("LBL_W4", new Object[0]), 4, 0, 9999, 1)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_KST_LINE", new Object[0]), defaults.getLineColor(), 1.5f, null, true, false, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("signalLine", this.get("LBL_SIGNAL_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, false)});
        settingGroup2 = settingTab.addGroup(this.get("LBL_MARKERS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        settingGroup2 = settingTab.addGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("signalInd", this.get("LBL_SIGNAL_IND", new Object[0]), null, null, false, false, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method", "signalMethod"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("signalPeriod", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 8, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "signalLine"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)KST$Values.KST, this.get("VAL_KST", new Object[0]), new String[]{"input", "method"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)KST$Values.SIGNAL, this.get("VAL_KST_SIGNAL", new Object[0]), new String[]{"input", "signalMethod"}));
        runtimeDescriptor.declarePath((Object)KST$Values.KST, "line");
        runtimeDescriptor.declarePath((Object)KST$Values.SIGNAL, "signalLine");
        runtimeDescriptor.declareIndicator((Object)KST$Values.KST, "ind");
        runtimeDescriptor.declareIndicator((Object)KST$Values.SIGNAL, "signalInd");
        runtimeDescriptor.declareSignal((Object)KST$Signals.CROSS_ABOVE, this.get("LBL_CROSS_ABOVE_SIGNAL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)KST$Signals.CROSS_BELOW, this.get("LBL_CROSS_BELOW_SIGNAL", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{KST$Values.KST, KST$Values.SIGNAL});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, null));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        int n4;
        int n5;
        Object object = this.getSettings().getInput("input");
        int n6 = this.getSettings().getInteger(e);
        int n7 = Util.maxInt((int[])new int[]{n6, n5 = this.getSettings().getInteger(f).intValue(), n4 = this.getSettings().getInteger(g).intValue(), n3 = this.getSettings().getInteger(h).intValue()});
        if (n2 < n7) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        dataSeries.setDouble(n2, (Object)KST$Values.ROC1, Double.valueOf(dataSeries.roc(n2, n6, object) * 100.0));
        dataSeries.setDouble(n2, (Object)KST$Values.ROC2, Double.valueOf(dataSeries.roc(n2, n5, object) * 100.0));
        dataSeries.setDouble(n2, (Object)KST$Values.ROC3, Double.valueOf(dataSeries.roc(n2, n4, object) * 100.0));
        dataSeries.setDouble(n2, (Object)KST$Values.ROC4, Double.valueOf(dataSeries.roc(n2, n3, object) * 100.0));
        int n8 = this.getSettings().getInteger(a);
        int n9 = this.getSettings().getInteger(b);
        int n10 = this.getSettings().getInteger(c);
        int n11 = this.getSettings().getInteger(d);
        int n12 = Util.maxInt((int[])new int[]{n8, n9, n10, n11});
        if (n2 < n7 + n12) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        int n13 = this.getSettings().getInteger(i);
        int n14 = this.getSettings().getInteger(j);
        int n15 = this.getSettings().getInteger(k);
        int n16 = this.getSettings().getInteger(l);
        Double d2 = dataSeries.ma(mAMethod, n2, n8, (Object)KST$Values.ROC1);
        Double d3 = dataSeries.ma(mAMethod, n2, n9, (Object)KST$Values.ROC2);
        Double d4 = dataSeries.ma(mAMethod, n2, n10, (Object)KST$Values.ROC3);
        Double d5 = dataSeries.ma(mAMethod, n2, n11, (Object)KST$Values.ROC4);
        if (d2 == null || d3 == null || d4 == null || d5 == null) {
            return;
        }
        double d6 = d2 * (double)n13 + d3 * (double)n14 + d4 * (double)n15 + d5 * (double)n16;
        dataSeries.setDouble(n2, (Object)KST$Values.KST, Double.valueOf(d6));
        int n17 = this.getSettings().getInteger("signalPeriod");
        if (n2 < n7 + n12 + n17) {
            return;
        }
        Double d7 = dataSeries.ma(this.getSettings().getMAMethod("signalMethod"), n2, n17, (Object)KST$Values.KST);
        dataSeries.setDouble(n2, (Object)KST$Values.SIGNAL, d7);
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        if (d7 != null) {
            Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d7.doubleValue());
            if (this.crossedAbove(dataSeries, n2, (Object)KST$Values.KST, (Object)KST$Values.SIGNAL)) {
                MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
                String string = this.get("SIGNAL_KST_CROSS_ABOVE", new Object[]{d6, d7});
                if (markerInfo.isEnabled()) {
                    this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
                }
                dataContext.signal(n2, (Object)KST$Signals.CROSS_ABOVE, string, (Object)d7);
            } else if (this.crossedBelow(dataSeries, n2, (Object)KST$Values.KST, (Object)KST$Values.SIGNAL)) {
                MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
                String string = this.get("SIGNAL_KST_CROSS_BELOW", new Object[]{d6, d7});
                if (markerInfo.isEnabled()) {
                    this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
                }
                dataContext.signal(n2, (Object)KST$Signals.CROSS_BELOW, string, (Object)d7);
            }
        }
        dataSeries.setComplete(n2);
    }
}

