/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.JRCFractalDim$Values;

@StudyHeader(namespace="com.motivewave", id="ID_JRCFD", rb="com.motivewave.platform.study.nls.strings2", name="NAME_JRC_FRACTAL_DIMENSION", label="LBL_JRCFD", desc="DESC_JRCFD", helpLink="http://www.motivewave.com/studies/jrc_fractal_dimension.htm", signals=false, overlay=false, studyOverlay=true)
public class JRCFractalDim
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("SIZE", new Object[0]), 20, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("COUNT", new Object[0]), 5, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("SMOOTH", new Object[0]), 5, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_JRCFD", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), null, null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 1.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("SIZE", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("COUNT", new Object[0]), 5, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period3", this.get("SMOOTH", new Object[0]), 5, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"method", "line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", "period3", "method"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)JRCFractalDim$Values.JRCFD, this.get("LBL_JRCFD", new Object[0]), new String[]{"input", "period", "period2", "period3", "method"}));
        runtimeDescriptor.declarePath((Object)JRCFractalDim$Values.JRCFD, "line");
        runtimeDescriptor.declareIndicator((Object)JRCFractalDim$Values.JRCFD, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{JRCFractalDim$Values.JRCFD});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        this.setMinBars(Math.max(Math.max(n2, n3), n4) + n2 * n3 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        double d2;
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        int n6 = Math.max(Math.max(n3, n4), n5);
        if (n2 < n6) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.SMA);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n7 = (n4 - 1) * n3;
        int n8 = n4 * n3;
        double d7 = Math.log(n4);
        double d8 = dataSeries.highest(n2, n3, (Object)Enums.BarInput.HIGH);
        double d9 = dataSeries.lowest(n2, n3, Enums.BarInput.LOW);
        double d10 = dataSeries.getDouble(n2 - n3, object, 0.0);
        d3 = Math.max(d10, d8) - Math.min(d10, d9);
        dataSeries.setDouble(n2, (Object)JRCFractalDim$Values.SR, Double.valueOf(d3));
        if (n2 < n6 + n8) {
            return;
        }
        d8 = dataSeries.highest(n2, n8, (Object)Enums.BarInput.HIGH);
        d9 = dataSeries.lowest(n2, n8, Enums.BarInput.LOW);
        d10 = dataSeries.getDouble(n2 - n8, object, 0.0);
        d4 = Math.max(d10, d8) - Math.min(d10, d9);
        double d11 = dataSeries.getDouble(n2 - 1, (Object)JRCFractalDim$Values.SS, d3);
        d5 = d11 + d3 - (d2 = dataSeries.getDouble(n2 - n7, (Object)JRCFractalDim$Values.SR, 0.0));
        if (d5 < 0.0) {
            return;
        }
        dataSeries.setDouble(n2, (Object)JRCFractalDim$Values.SS, Double.valueOf(d5));
        if (n2 < n6 + n8 + 1) {
            return;
        }
        double d12 = Math.log(d4 / (d5 / (double)n7));
        d6 = 2.0 - d12 / d7;
        dataSeries.setDouble(n2, (Object)JRCFractalDim$Values.FD, Double.valueOf(d6));
        if (n2 < n6 + n8 + 1 + n5) {
            return;
        }
        Double d13 = dataSeries.ma(mAMethod, n2, n5, (Object)JRCFractalDim$Values.FD);
        dataSeries.setDouble(n2, (Object)JRCFractalDim$Values.JRCFD, d13);
        dataSeries.setComplete(n2);
    }
}

