/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.ForceIndex$Values;

@StudyHeader(namespace="com.motivewave", id="FI", rb="com.motivewave.platform.study.nls.strings", name="TITLE_FI", desc="DESC_FI", menu="MENU_GENERAL", overlay=false, studyOverlay=true, helpLink="http://www.motivewave.com/studies/force_index.htm")
public class ForceIndex
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 13, 1, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_COLORS", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, false);
        pathDescriptor.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "line", 0.0, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "line", 0.0, Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 13, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ForceIndex$Values.MA, this.get("LBL_FI", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declarePath((Object)ForceIndex$Values.MA, "line");
        runtimeDescriptor.declareIndicator((Object)ForceIndex$Values.MA, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{ForceIndex$Values.MA});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period", 13);
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = (dataSeries.getClose(n2) - dataSeries.getClose(n2 - 1)) * (float)dataSeries.getVolume(n2);
        dataSeries.setDouble(n2, (Object)ForceIndex$Values.FI, Double.valueOf(d2));
        if (n2 < n3 + 1) {
            return;
        }
        dataSeries.setDouble(n2, (Object)ForceIndex$Values.MA, dataSeries.ema(n2, n3, (Object)ForceIndex$Values.FI));
        dataSeries.setComplete(n2);
    }
}

