/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.FastSlowST$Values;
import com.motivewave.platform.study.general.j;

@StudyHeader(namespace="com.motivewave", id="ID_FSST", rb="com.motivewave.platform.study.nls.strings2", name="NAME_FAST_SLOW_ST", desc="DESC_FSST", label="LBL_FSST", helpLink="http://www.motivewave.com/studies/fast_and_slow_st.htm", signals=false, overlay=false, studyOverlay=true)
public class FastSlowST
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD1", new Object[0]), 3, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERIOD2", new Object[0]), 6, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("PERIOD3", new Object[0]), 9, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period4", this.get("PERIOD4", new Object[0]), 9, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("SIGNAL_METHOD", new Object[0]), Enums.MAMethod.WMA)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_FSST", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("SIGNAL", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_FSST", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SIGNAL", new Object[0]), defaults.getRed(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 50.0, -999.1, 999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup2 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD1", new Object[0]), 3, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("PERIOD2", new Object[0]), 6, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period3", this.get("PERIOD3", new Object[0]), 9, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period4", this.get("PERIOD4", new Object[0]), 9, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"method", "line", "line2"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", "period3", "period4", "method"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)FastSlowST$Values.FSST, this.get("LBL_FSST", new Object[0]), new String[]{"input", "period", "period2", "period3", "period4", "method"}));
        runtimeDescriptor.declarePath((Object)FastSlowST$Values.FSST, "line");
        runtimeDescriptor.declarePath((Object)FastSlowST$Values.WFSST, "line2");
        runtimeDescriptor.declareIndicator((Object)FastSlowST$Values.FSST, "ind");
        runtimeDescriptor.declareIndicator((Object)FastSlowST$Values.WFSST, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{FastSlowST$Values.FSST, FastSlowST$Values.WFSST});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        int n5 = this.getSettings().getInteger("period4");
        this.setMinBars(n2 + n3 + n4 * 2 + n5 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        int n6 = this.getSettings().getInteger("period4");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.WMA);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = j.a(dataContext, n2, n3, object);
        dataSeries.setDouble(n2, (Object)FastSlowST$Values.MOM, Double.valueOf(d2));
        if (n2 < n3 + 1) {
            return;
        }
        double d3 = dataSeries.getDouble(n2 - 1, (Object)FastSlowST$Values.MOM);
        double d4 = dataSeries.getDouble(n2 - 1, (Object)FastSlowST$Values.FSK, 0.0);
        double d5 = 0.03 * (d2 - d3) + 0.97 * d4;
        dataSeries.setDouble(n2, (Object)FastSlowST$Values.FSK, Double.valueOf(d5));
        if (n2 < n3 + n4 + 1) {
            return;
        }
        Double d6 = dataSeries.ma(mAMethod, n2, n4, (Object)FastSlowST$Values.FSK);
        dataSeries.setDouble(n2, (Object)FastSlowST$Values.V4, d6);
        if (n2 < n3 + n4 + n5 + 1) {
            return;
        }
        double d7 = j.d(dataSeries, n2, n5, object);
        dataSeries.setDouble(n2, (Object)FastSlowST$Values.FASTK, Double.valueOf(d7));
        if (n2 < n3 + n4 + n5 * 2 + 1) {
            return;
        }
        Double d8 = dataSeries.ma(mAMethod, n2, n5, (Object)FastSlowST$Values.FASTK);
        if (d8 == null) {
            return;
        }
        double d9 = 500.0 * d6 + d8;
        dataSeries.setDouble(n2, (Object)FastSlowST$Values.FSST, Double.valueOf(d9));
        if (n2 < n3 + n4 + n5 * 2 + n6 + 1) {
            return;
        }
        Double d10 = dataSeries.ma(mAMethod, n2, n6, (Object)FastSlowST$Values.FSST);
        dataSeries.setDouble(n2, (Object)FastSlowST$Values.WFSST, d10);
        dataSeries.setComplete(n2);
    }
}

