/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.FastSlowRelativeStrengthIndex$Signals;
import com.motivewave.platform.study.general.FastSlowRelativeStrengthIndex$Values;
import com.motivewave.platform.study.general.j;

@StudyHeader(namespace="com.motivewave", id="ID_FSRSI", rb="com.motivewave.platform.study.nls.strings2", name="NAME_FAST_SLOW_RSI", desc="DESC_FSRSI", label="LBL_FSRSI", helpLink="http://www.motivewave.com/studies/fast_and_slow_rsi.htm", signals=true, overlay=false, studyOverlay=true)
public class FastSlowRelativeStrengthIndex
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("MOMENTUM_PERIOD", new Object[0]), 3, 1, 500, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("FSK_PERIOD", new Object[0]), 6, 1, 500, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("RSI_PERIOD", new Object[0]), 9, 1, 500, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("RSI_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period4", this.get("SIGNAL_PERIOD", new Object[0]), 6, 1, 500, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method2", this.get("SIGNAL_METHOD", new Object[0]), Enums.MAMethod.WMA)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_FSRSI", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("SIGNAL", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_FSRSI", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SIGNAL", new Object[0]), defaults.getRed(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup2 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("MOMENTUM_PERIOD", new Object[0]), 3, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("FSK_PERIOD", new Object[0]), 6, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period3", this.get("RSI_PERIOD", new Object[0]), 9, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period4", this.get("SIGNAL_PERIOD", new Object[0]), 6, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"method2", "line", "line2"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", "period3", "period4", "method", "method2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)FastSlowRelativeStrengthIndex$Values.FSRSI, this.get("LBL_FSRSI", new Object[0]), new String[]{"input", "period", "period2", "period3", "period4", "method"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)FastSlowRelativeStrengthIndex$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)FastSlowRelativeStrengthIndex$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declarePath((Object)FastSlowRelativeStrengthIndex$Values.FSRSI, "line");
        runtimeDescriptor.declarePath((Object)FastSlowRelativeStrengthIndex$Values.SIG, "line2");
        runtimeDescriptor.declareIndicator((Object)FastSlowRelativeStrengthIndex$Values.FSRSI, "ind");
        runtimeDescriptor.declareIndicator((Object)FastSlowRelativeStrengthIndex$Values.SIG, "ind2");
        runtimeDescriptor.declareSignal((Object)FastSlowRelativeStrengthIndex$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)FastSlowRelativeStrengthIndex$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{FastSlowRelativeStrengthIndex$Values.FSRSI, FastSlowRelativeStrengthIndex$Values.SIG});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        int n5 = this.getSettings().getInteger("period4");
        this.setMinBars(n2 + n3 + n4 + n5 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        int n6 = this.getSettings().getInteger("period4");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        Enums.MAMethod mAMethod2 = this.getSettings().getMAMethod("method2", Enums.MAMethod.WMA);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = j.a(dataContext, n2, n3, object);
        dataSeries.setDouble(n2, (Object)FastSlowRelativeStrengthIndex$Values.MOM, Double.valueOf(d3));
        if (n2 < n3 + 1) {
            return;
        }
        double d4 = dataSeries.getDouble(n2 - 1, (Object)FastSlowRelativeStrengthIndex$Values.MOM);
        double d5 = dataSeries.getDouble(n2 - 1, (Object)FastSlowRelativeStrengthIndex$Values.FSK, 0.0);
        double d6 = 0.03 * (d3 - d4) + 0.97 * d5;
        dataSeries.setDouble(n2, (Object)FastSlowRelativeStrengthIndex$Values.FSK, Double.valueOf(d6));
        if (n2 < n3 + n4 + 1) {
            return;
        }
        Double d7 = dataSeries.ma(mAMethod2, n2, n4, (Object)FastSlowRelativeStrengthIndex$Values.FSK);
        if (d7 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)FastSlowRelativeStrengthIndex$Values.V4, d7);
        double d8 = dataSeries.getDouble(n2, object) - dataSeries.getDouble(n2 - 1, object);
        double d9 = 0.0;
        double d10 = 0.0;
        if (d8 > 0.0) {
            d9 = d8;
        } else {
            d10 = d8;
        }
        dataSeries.setDouble(n2, (Object)FastSlowRelativeStrengthIndex$Values.UP, Double.valueOf(d9));
        dataSeries.setDouble(n2, (Object)FastSlowRelativeStrengthIndex$Values.DOWN, Double.valueOf(Math.abs(d10)));
        if (n2 < n3 + n4 + n5 + 1) {
            return;
        }
        Double d11 = dataSeries.ma(mAMethod, n2, n5, (Object)FastSlowRelativeStrengthIndex$Values.UP);
        if (d11 == null) {
            return;
        }
        Double d12 = dataSeries.ma(mAMethod, n2, n5, (Object)FastSlowRelativeStrengthIndex$Values.DOWN);
        if (d12 == null) {
            return;
        }
        double d13 = d11 / d12;
        double d14 = 100.0 - 100.0 / (1.0 + d13);
        double d15 = 10000.0 * d7 + d14;
        dataSeries.setDouble(n2, (Object)FastSlowRelativeStrengthIndex$Values.FSRSI, Double.valueOf(d15));
        if (n2 < n3 + n4 + n5 + n6 + 1) {
            return;
        }
        Double d16 = dataSeries.ma(mAMethod2, n2, n6, (Object)FastSlowRelativeStrengthIndex$Values.FSRSI);
        if (d16 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)FastSlowRelativeStrengthIndex$Values.SIG, d16);
        boolean bl2 = this.crossedAbove(dataSeries, n2, (Object)FastSlowRelativeStrengthIndex$Values.FSRSI, (Object)FastSlowRelativeStrengthIndex$Values.SIG);
        boolean bl3 = this.crossedBelow(dataSeries, n2, (Object)FastSlowRelativeStrengthIndex$Values.FSRSI, (Object)FastSlowRelativeStrengthIndex$Values.SIG);
        dataSeries.setBoolean(n2, (Object)FastSlowRelativeStrengthIndex$Signals.SELL, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)FastSlowRelativeStrengthIndex$Signals.BUY, Boolean.valueOf(bl2));
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d15);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_FSRSI", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d15, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)FastSlowRelativeStrengthIndex$Signals.SELL, string, (Object)d2);
        }
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d15);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_FSRSI", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d15, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)FastSlowRelativeStrengthIndex$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

