/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.ErgodicTrueStrengthIndex$Values;

@StudyHeader(namespace="com.motivewave", id="ID_ETSI", rb="com.motivewave.platform.study.nls.strings2", name="NAME_ERGODIC_TRUE_STRENGTH_INDEX", desc="DESC_ETSI", label="LBL_ETSI", menu="MENU_WILLIAM_BLAU", helpLink="http://www.motivewave.com/studies/ergodic_true_strength_index.htm", signals=false, overlay=false, studyOverlay=true)
public class ErgodicTrueStrengthIndex
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD1", new Object[0]), 4, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERIOD2", new Object[0]), 8, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("PERIOD3", new Object[0]), 6, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period4", this.get("SMOOTH_PERIOD", new Object[0]), 3, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_ETSI", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("SIGNAL", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_ETSI", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SIGNAL", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup2 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "line", 0.0, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "line", 0.0, Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD1", new Object[0]), 4, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("PERIOD2", new Object[0]), 8, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period3", this.get("PERIOD3", new Object[0]), 6, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period4", this.get("SMOOTH_PERIOD", new Object[0]), 3, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"method", "line", "line2", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", "period3", "period4", "method"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ErgodicTrueStrengthIndex$Values.ETSI, this.get("LBL_ETSI", new Object[0]), new String[]{"input", "period", "period2", "period3", "period4", "method"}));
        runtimeDescriptor.declarePath((Object)ErgodicTrueStrengthIndex$Values.ETSI, "line");
        runtimeDescriptor.declarePath((Object)ErgodicTrueStrengthIndex$Values.SIG, "line2");
        runtimeDescriptor.declareIndicator((Object)ErgodicTrueStrengthIndex$Values.ETSI, "ind");
        runtimeDescriptor.declareIndicator((Object)ErgodicTrueStrengthIndex$Values.SIG, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{ErgodicTrueStrengthIndex$Values.ETSI, ErgodicTrueStrengthIndex$Values.SIG});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        int n5 = this.getSettings().getInteger("period4");
        this.setMinBars(n2 + n3 + n4 + n5 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        int n6 = this.getSettings().getInteger("period4");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.0;
        double d3 = dataSeries.getDouble(n2, object, 0.0);
        double d4 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d5 = d3 - d4;
        double d6 = Math.abs(d3 - d4);
        dataSeries.setDouble(n2, (Object)ErgodicTrueStrengthIndex$Values.PRICE_D, Double.valueOf(d5));
        dataSeries.setDouble(n2, (Object)ErgodicTrueStrengthIndex$Values.ABS_PRICE_D, Double.valueOf(d6));
        if (n2 < n3 + 1) {
            return;
        }
        Double d7 = dataSeries.ma(mAMethod, n2, n3, (Object)ErgodicTrueStrengthIndex$Values.PRICE_D);
        Double d8 = dataSeries.ma(mAMethod, n2, n3, (Object)ErgodicTrueStrengthIndex$Values.ABS_PRICE_D);
        dataSeries.setDouble(n2, (Object)ErgodicTrueStrengthIndex$Values.MA1, d7);
        dataSeries.setDouble(n2, (Object)ErgodicTrueStrengthIndex$Values.AMA1, d8);
        if (n2 < n3 + n4 + 1) {
            return;
        }
        Double d9 = dataSeries.ma(mAMethod, n2, n4, (Object)ErgodicTrueStrengthIndex$Values.MA1);
        Double d10 = dataSeries.ma(mAMethod, n2, n4, (Object)ErgodicTrueStrengthIndex$Values.AMA1);
        dataSeries.setDouble(n2, (Object)ErgodicTrueStrengthIndex$Values.MA2, d9);
        dataSeries.setDouble(n2, (Object)ErgodicTrueStrengthIndex$Values.AMA2, d10);
        if (n2 < n3 + n4 + n5 + 1) {
            return;
        }
        Double d11 = dataSeries.ma(mAMethod, n2, n5, (Object)ErgodicTrueStrengthIndex$Values.MA2);
        Double d12 = dataSeries.ma(mAMethod, n2, n5, (Object)ErgodicTrueStrengthIndex$Values.AMA2);
        if (d11 == null || d12 == null) {
            return;
        }
        if (d12 != 0.0) {
            d2 = 100.0 * d11 / d12;
            dataSeries.setDouble(n2, (Object)ErgodicTrueStrengthIndex$Values.ETSI, Double.valueOf(d2));
        }
        if (n2 < n3 + n4 + n5 + n6 + 1) {
            return;
        }
        Double d13 = dataSeries.ma(mAMethod, n2, n6, (Object)ErgodicTrueStrengthIndex$Values.ETSI);
        dataSeries.setDouble(n2, (Object)ErgodicTrueStrengthIndex$Values.SIG, d13);
        dataSeries.setComplete(n2);
    }
}

