/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.ErgodicMeanDevInd$Signals;
import com.motivewave.platform.study.general.ErgodicMeanDevInd$Values;

@StudyHeader(namespace="com.motivewave", id="ID_EMDI", rb="com.motivewave.platform.study.nls.strings2", name="NAME_ERGODIC_MEAN_DEVIATION_IND", desc="DESC_EMDI", menu="MENU_WILLIAM_BLAU", label="LBL_EMDI", helpLink="http://www.motivewave.com/studies/ergodic_mean_deviation_ind.htm", signals=true, overlay=false, studyOverlay=true)
public class ErgodicMeanDevInd
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD1", new Object[0]), 32, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERIOD2", new Object[0]), 5, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("PERIOD3", new Object[0]), 5, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period4", this.get("SMOOTH_PERIOD", new Object[0]), 5, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD1", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method2", this.get("METHOD2", new Object[0]), Enums.MAMethod.EMA)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_EMDI", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("SIGNAL", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        settingGroup2 = settingTab.addGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_EMDI", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SIGNAL", new Object[0]), defaults.getRed(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -9.01, 9.01, 0.01, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup2 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD1", new Object[0]), 32, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("PERIOD2", new Object[0]), 5, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period3", this.get("PERIOD3", new Object[0]), 5, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period4", this.get("SMOOTH_PERIOD", new Object[0]), 5, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"method", "method2", "line", "line2", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", "period3", "period4", "method", "method2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ErgodicMeanDevInd$Values.EMDI, this.get("LBL_EMDI", new Object[0]), new String[]{"input", "period", "period2", "period3", "period4", "method", "method2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ErgodicMeanDevInd$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ErgodicMeanDevInd$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)ErgodicMeanDevInd$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)ErgodicMeanDevInd$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)ErgodicMeanDevInd$Values.EMDI, "line");
        runtimeDescriptor.declarePath((Object)ErgodicMeanDevInd$Values.SIG, "line2");
        runtimeDescriptor.declareIndicator((Object)ErgodicMeanDevInd$Values.EMDI, "ind");
        runtimeDescriptor.declareIndicator((Object)ErgodicMeanDevInd$Values.SIG, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{ErgodicMeanDevInd$Values.EMDI, ErgodicMeanDevInd$Values.SIG});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        int n5 = this.getSettings().getInteger("period4");
        this.setMinBars(n2 + n3 + n4 + n5);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        int n6 = this.getSettings().getInteger("period4");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        Enums.MAMethod mAMethod2 = this.getSettings().getMAMethod("method2", Enums.MAMethod.EMA);
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d2 == null) {
            return;
        }
        double d3 = dataSeries.getDouble(n2, object, 0.0);
        double d4 = d3 - d2;
        dataSeries.setDouble(n2, (Object)ErgodicMeanDevInd$Values.MA1, Double.valueOf(d4));
        if (n2 < n3 + n4) {
            return;
        }
        Double d5 = dataSeries.ma(mAMethod, n2, n4, (Object)ErgodicMeanDevInd$Values.MA1);
        dataSeries.setDouble(n2, (Object)ErgodicMeanDevInd$Values.MA2, d5);
        if (n2 < n3 + n4 + n5) {
            return;
        }
        Double d6 = dataSeries.ma(mAMethod, n2, n5, (Object)ErgodicMeanDevInd$Values.MA2);
        dataSeries.setDouble(n2, (Object)ErgodicMeanDevInd$Values.EMDI, d6);
        if (n2 < n3 + n4 + n5 + n6) {
            return;
        }
        Double d7 = dataSeries.ma(mAMethod2, n2, n6, (Object)ErgodicMeanDevInd$Values.EMDI);
        dataSeries.setDouble(n2, (Object)ErgodicMeanDevInd$Values.SIG, d7);
        boolean bl2 = this.crossedAbove(dataSeries, n2, (Object)ErgodicMeanDevInd$Values.EMDI, (Object)ErgodicMeanDevInd$Values.SIG);
        boolean bl3 = this.crossedBelow(dataSeries, n2, (Object)ErgodicMeanDevInd$Values.EMDI, (Object)ErgodicMeanDevInd$Values.SIG);
        dataSeries.setBoolean(n2, (Object)ErgodicMeanDevInd$Signals.SELL, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)ErgodicMeanDevInd$Signals.BUY, Boolean.valueOf(bl2));
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d6.doubleValue());
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_EMDI", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d6, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)ErgodicMeanDevInd$Signals.SELL, string, (Object)d3);
        }
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d6.doubleValue());
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_EMDI", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d6, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)ErgodicMeanDevInd$Signals.BUY, string, (Object)d3);
        }
        dataSeries.setComplete(n2);
    }
}

