/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.DirectionalTrendIndex$Signals;
import com.motivewave.platform.study.general.DirectionalTrendIndex$Values;

@StudyHeader(namespace="com.motivewave", id="ID_WBDTI", rb="com.motivewave.platform.study.nls.strings2", name="NAME_DIRECTIONAL_TREND_INDEX", desc="DESC_WBDTI", menu="MENU_WILLIAM_BLAU", helpLink="http://www.motivewave.com/studies/directional_trend_index.htm", label="LBL_WBDTI", signals=true, overlay=false, studyOverlay=true)
public class DirectionalTrendIndex
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD_R", new Object[0]), 14, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERIOD_S", new Object[0]), 10, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("PERIOD_U", new Object[0]), 5, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_WBDTI", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), null, null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 25.0, 0.0, 100.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -100.1, 100.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), -25.0, -100.1, 0.0, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingGroup2 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD_R", new Object[0]), 14, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("PERIOD_S", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period3", this.get("PERIOD_U", new Object[0]), 5, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"method", "period", "period2", "period3"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DirectionalTrendIndex$Values.DTI, this.get("LBL_WBDTI", new Object[0]), new String[]{"method", "period", "period2", "period3"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DirectionalTrendIndex$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DirectionalTrendIndex$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)DirectionalTrendIndex$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)DirectionalTrendIndex$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)DirectionalTrendIndex$Values.DTI, "line");
        runtimeDescriptor.declareIndicator((Object)DirectionalTrendIndex$Values.DTI, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{DirectionalTrendIndex$Values.DTI});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        this.setMinBars(n2 + n3 + n4 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getHigh(n2);
        double d3 = dataSeries.getHigh(n2 - 1);
        double d4 = dataSeries.getLow(n2);
        double d5 = dataSeries.getLow(n2 - 1);
        double d6 = 0.0;
        if (d2 - d3 > 0.0) {
            d6 = d2 - d3;
        }
        double d7 = 0.0;
        if (d4 - d5 < 0.0) {
            d7 = -(d4 - d5);
        }
        dataSeries.setDouble(n2, (Object)DirectionalTrendIndex$Values.HMU_LMD, Double.valueOf(d6 - d7));
        dataSeries.setDouble(n2, (Object)DirectionalTrendIndex$Values.ABS_HMU_LMD, Double.valueOf(Math.abs(d6 - d7)));
        if (n2 < n3 + 1) {
            return;
        }
        Double d8 = dataSeries.ma(mAMethod, n2, n3, (Object)DirectionalTrendIndex$Values.HMU_LMD);
        Double d9 = dataSeries.ma(mAMethod, n2, n3, (Object)DirectionalTrendIndex$Values.ABS_HMU_LMD);
        dataSeries.setDouble(n2, (Object)DirectionalTrendIndex$Values.MA1, d8);
        dataSeries.setDouble(n2, (Object)DirectionalTrendIndex$Values.ABS_MA1, d9);
        if (n2 < n3 + n4 + 1) {
            return;
        }
        Double d10 = dataSeries.ma(mAMethod, n2, n4, (Object)DirectionalTrendIndex$Values.MA1);
        Double d11 = dataSeries.ma(mAMethod, n2, n4, (Object)DirectionalTrendIndex$Values.ABS_MA1);
        dataSeries.setDouble(n2, (Object)DirectionalTrendIndex$Values.MA2, d10);
        dataSeries.setDouble(n2, (Object)DirectionalTrendIndex$Values.ABS_MA2, d11);
        if (n2 < n3 + n4 + n5 + 1) {
            return;
        }
        Double d12 = dataSeries.ma(mAMethod, n2, n5, (Object)DirectionalTrendIndex$Values.MA2);
        Double d13 = dataSeries.ma(mAMethod, n2, n5, (Object)DirectionalTrendIndex$Values.ABS_MA2);
        if (d12 == null || d13 == null) {
            return;
        }
        double d14 = 100.0 * d12 / d13;
        dataSeries.setDouble(n2, (Object)DirectionalTrendIndex$Values.DTI, Double.valueOf(d14));
        dataSeries.setComplete(n2);
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d15 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d16 = guideInfo2.getValue();
        double d17 = dataSeries.getDouble(n2 - 1, (Object)DirectionalTrendIndex$Values.DTI, 0.0);
        boolean bl2 = d14 > d15 && d17 > d14 && d14 > this.a;
        boolean bl3 = d14 < d16 && d17 < d14 && d14 < this.b;
        boolean bl4 = n2 == dataSeries.size() - 1 && dataSeries.getBoolean(n2, (Object)DirectionalTrendIndex$Signals.BUY, false);
        boolean bl5 = n2 == dataSeries.size() - 1 && dataSeries.getBoolean(n2, (Object)DirectionalTrendIndex$Signals.SELL, false);
        dataSeries.setBoolean(n2, (Object)DirectionalTrendIndex$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)DirectionalTrendIndex$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d14;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d14);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_HIGH_DTI", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d14, (int)3)});
            if (!bl5 && markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DirectionalTrendIndex$Signals.SELL, string, (Object)d2);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d14;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d14);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_LOW_DTI", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d14, (int)3)});
            if (!bl4 && markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DirectionalTrendIndex$Signals.BUY, string, (Object)d4);
        }
    }
}

