/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.DetrendedSynPrice$Values;

@StudyHeader(namespace="com.motivewave", id="ID_DSNP", rb="com.motivewave.platform.study.nls.strings2", name="NAME_DETRENDED_SYNTHETIC_PRICE", label="LBL_DSNP", desc="DESC_DSNP", menu="MENU_BILL_MARS", helpLink="http://www.motivewave.com/studies/detrended_synthetic_price.htm", overlay=false, signals=false, studyOverlay=true)
public class DetrendedSynPrice
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUT", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 14, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_DSNP", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "line", 0.0, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "line", 0.0, Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 14, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DetrendedSynPrice$Values.DSNP, this.get("DSNP", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declarePath((Object)DetrendedSynPrice$Values.DSNP, "line");
        runtimeDescriptor.declareIndicator((Object)DetrendedSynPrice$Values.DSNP, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{DetrendedSynPrice$Values.DSNP});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, (Object)Enums.BarInput.HIGH, 0.0);
        double d3 = dataSeries.getDouble(n2, (Object)Enums.BarInput.LOW, 0.0);
        double d4 = dataSeries.getDouble(n2 - 1, (Object)Enums.BarInput.HIGH, 0.0);
        double d5 = dataSeries.getDouble(n2 - 1, (Object)Enums.BarInput.LOW, 0.0);
        if (d4 > d2) {
            d2 = d4;
        }
        if (d5 < d3) {
            d3 = d5;
        }
        double d6 = (d2 + d3) / 2.0;
        double d7 = 0.67;
        if (n3 > 2) {
            d7 = 2.0 / (double)(n3 + 1);
        }
        double d8 = dataSeries.getDouble(n2 - 1, (Object)DetrendedSynPrice$Values.EMA1, d6);
        double d9 = d7 * d6 + (1.0 - d7) * d8;
        dataSeries.setDouble(n2, (Object)DetrendedSynPrice$Values.EMA1, Double.valueOf(d9));
        double d10 = dataSeries.getDouble(n2 - 1, (Object)DetrendedSynPrice$Values.EMA2, d6);
        double d11 = d7 / 2.0 * d6 + (1.0 - d7 / 2.0) * d10;
        dataSeries.setDouble(n2, (Object)DetrendedSynPrice$Values.EMA2, Double.valueOf(d11));
        double d12 = d9 - d11;
        dataSeries.setDouble(n2, (Object)DetrendedSynPrice$Values.DSNP, Double.valueOf(d12));
        dataSeries.setComplete(n2);
    }
}

