/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.DetrendedPriceOscillator$Signals;
import com.motivewave.platform.study.general.DetrendedPriceOscillator$Values;

@StudyHeader(namespace="com.motivewave", id="ID_DPO", rb="com.motivewave.platform.study.nls.strings2", name="NAME_DETRENDED_PRICE_OSCILLATOR", label="LBL_DPO", desc="DESC_DPO", helpLink="http://www.motivewave.com/studies/detrended_price_oscillator.htm", overlay=false, signals=true, studyOverlay=true)
public class DetrendedPriceOscillator
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 20, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_DPO", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 0.01, 0.0, 9999.001, 0.001, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -999.001, 999.001, 0.001, false);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), -0.01, -9999.001, 0.0, 0.001, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingGroup2 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DetrendedPriceOscillator$Values.DPO, this.get("LBL_DPO", new Object[0]), new String[]{"input", "method", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DetrendedPriceOscillator$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DetrendedPriceOscillator$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)DetrendedPriceOscillator$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)DetrendedPriceOscillator$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)DetrendedPriceOscillator$Values.DPO, "line");
        runtimeDescriptor.declareIndicator((Object)DetrendedPriceOscillator$Values.DPO, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{DetrendedPriceOscillator$Values.DPO});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 + (n2 / 2 + 1));
    }

    protected void calculate(int n2, DataContext dataContext) {
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3;
        int n4 = this.getSettings().getInteger("period");
        if (n2 < n4 + (n3 = n4 / 2 + 1)) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.SMA);
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        Double d3 = dataSeries.ma(mAMethod, n2 - n3, n4, object);
        if (d3 == null) {
            return;
        }
        double d4 = d2 - d3;
        dataSeries.setDouble(n2, (Object)DetrendedPriceOscillator$Values.DPO, Double.valueOf(d4));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d5 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d6 = guideInfo2.getValue();
        double d7 = dataSeries.getDouble(n2 - 1, (Object)DetrendedPriceOscillator$Values.DPO, 0.0);
        boolean bl2 = d4 > d5 && d7 > d4 && d4 > this.a;
        boolean bl3 = d4 < d6 && d7 < d4 && d4 < this.b;
        boolean bl4 = n2 == dataSeries.size() - 1 && dataSeries.getBoolean(n2, (Object)DetrendedPriceOscillator$Signals.BUY, false);
        boolean bl5 = n2 == dataSeries.size() - 1 && dataSeries.getBoolean(n2, (Object)DetrendedPriceOscillator$Signals.SELL, false);
        dataSeries.setBoolean(n2, (Object)DetrendedPriceOscillator$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)DetrendedPriceOscillator$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.a = d4;
            this.b = Double.MAX_VALUE;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d4);
            markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("SELL_DETRENDED_PRICE_OSCILLATOR_PRICE_DPO", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d4, (int)3)});
            if (!bl5 && markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DetrendedPriceOscillator$Signals.SELL, string, (Object)d2);
        }
        if (bl3) {
            this.b = d4;
            this.a = Double.NEGATIVE_INFINITY;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d4);
            markerInfo = this.getSettings().getMarker("upMarker");
            if (!bl4 && markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo));
            }
            dataContext.signal(n2, (Object)DetrendedPriceOscillator$Signals.BUY, this.get("BUY_DETRENDED_PRICE_OSCILLATOR_PRICE_DPO", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d4, (int)3)}), (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

