/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.DSSBressert$Values;

@StudyHeader(namespace="com.motivewave", id="DSS_BRESSERT", rb="com.motivewave.platform.study.nls.strings", label="LBL_BRESSERT_DSS", name="LBL_BRESSERT_DSS", desc="DESC_BRESSERT_DSS", menu="MENU_GENERAL", signals=true, overlay=false, studyOverlay=true)
public class DSSBressert
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_K_PERIOD", new Object[0]), 10, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LBL_EMA_PERIOD", new Object[0]), 9, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("LBL_TRIGGER_PERIOD", new Object[0]), 5, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_BDSS", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("LBL_BDSS_TRIGGER", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingGroup2 = settingTab.addGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_BDSS", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("LBL_BDSS_TRIGGER", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("LBL_GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 80.0, 0.0, 999.0, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("LBL_MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.0, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        guideDescriptor2.setEnabled(false);
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), 20.0, 0.0, 999.0, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingGroup2 = settingTab.addGroup(this.get("LBL_SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "topGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "bottomGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_K_PERIOD", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("LBL_EMA_PERIOD", new Object[0]), 9, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period3", this.get("LBL_TRIGGER_PERIOD", new Object[0]), 5, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "line2"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"period", "period2", "period3"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DSSBressert$Values.DSS, this.get("LBL_BDSS", new Object[0]), new String[]{"period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DSSBressert$Values.TRIGGER, this.get("LBL_BDSS_TRIGGER", new Object[0]), new String[]{"period3"}));
        runtimeDescriptor.declarePath((Object)DSSBressert$Values.DSS, "line");
        runtimeDescriptor.declarePath((Object)DSSBressert$Values.TRIGGER, "line2");
        runtimeDescriptor.declareIndicator((Object)DSSBressert$Values.DSS, "ind");
        runtimeDescriptor.declareIndicator((Object)DSSBressert$Values.TRIGGER, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{DSSBressert$Values.DSS, DSSBressert$Values.TRIGGER});
        runtimeDescriptor.setMinTick(Double.valueOf(0.01));
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        this.setMinBars(n2 * 2 + n3 * 4 + n4 * 2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.stochasticK(n2, n3);
        if (d2 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)DSSBressert$Values.S1, d2);
        Double d3 = dataSeries.ema(n2, n4, (Object)DSSBressert$Values.S1);
        if (d3 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)DSSBressert$Values.SS, d3);
        Double d4 = dataSeries.stochasticK(n2, n3, (Object)DSSBressert$Values.SS);
        if (d4 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)DSSBressert$Values.S2, d4);
        Double d5 = dataSeries.ema(n2, n4, (Object)DSSBressert$Values.S2);
        if (d5 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)DSSBressert$Values.DSS, d5);
        Double d6 = dataSeries.ema(n2, n5, (Object)DSSBressert$Values.DSS);
        if (d6 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)DSSBressert$Values.TRIGGER, d6);
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

