/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.InstrumentDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.CorrelationCoeff$Values;

@StudyHeader(namespace="com.motivewave", id="ID_CORR_COEFF", rb="com.motivewave.platform.study.nls.strings2", label="LBL_CC", name="NAME_CORRELATION_COEFF", desc="DESC_CORR_COEFF", helpLink="", signals=false, overlay=false, multipleInstrument=true, studyOverlay=true)
public class CorrelationCoeff
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new InstrumentDescriptor("instrument1", this.get("INSTRUMENT1", new Object[0]), true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new InstrumentDescriptor("instrument2", this.get("INSTRUMENT2", new Object[0]))});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 10, 1, 999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), -1.0, 0.0, 1.0, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup2 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("PERIOD", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "instrument1", "instrument2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CorrelationCoeff$Values.CC, this.get("LBL_CC", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.declarePath((Object)CorrelationCoeff$Values.CC, "line");
        runtimeDescriptor.declareIndicator((Object)CorrelationCoeff$Values.CC, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{CorrelationCoeff$Values.CC});
        runtimeDescriptor.setBottomInsetPixels(10);
        runtimeDescriptor.setTopInsetPixels(10);
    }

    public void onLoad(Defaults defaults) {
        this.setMinBars(this.getSettings().getInteger("period"));
    }

    protected void calculate(int n2, DataContext dataContext) {
        Instrument instrument;
        int n3 = this.getSettings().getInteger("period");
        if (n2 <= n3) {
            return;
        }
        Enums.BarInput barInput = (Enums.BarInput)this.getSettings().getInput("input");
        Instrument instrument2 = this.getSettings().getInstrument("instrument1");
        if (instrument2 == null) {
            instrument2 = dataContext.getInstrument();
        }
        if ((instrument = this.getSettings().getInstrument("instrument2")) == null) {
            instrument = dataContext.getInstrument();
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        for (int i2 = n2 - n3 + 1; i2 <= n2; ++i2) {
            Float f10 = dataSeries.getFloat(i2, barInput, instrument2);
            Float f11 = dataSeries.getFloat(i2, barInput, instrument);
            if (f10 == null || f11 == null) {
                return;
            }
            f2 = f10.floatValue() * f10.floatValue();
            f3 = f11.floatValue() * f11.floatValue();
            f4 = f10.floatValue() * f11.floatValue();
            f5 += f10.floatValue();
            f6 += f11.floatValue();
            f7 += f2;
            f8 += f3;
            f9 += f4;
        }
        float f12 = f5 / (float)n3;
        float f13 = f6 / (float)n3;
        float f14 = f7 / (float)n3;
        float f15 = f8 / (float)n3;
        float f16 = f9 / (float)n3;
        float f17 = f14 - f12 * f12;
        if (f17 <= 0.0f) {
            return;
        }
        float f18 = f15 - f13 * f13;
        if (f18 <= 0.0f) {
            return;
        }
        float f19 = f16 - f12 * f13;
        if (f19 == 0.0f) {
            return;
        }
        Float f20 = Float.valueOf((float)((double)f19 / Math.sqrt(f17 * f18)));
        dataSeries.setFloat(n2, (Object)CorrelationCoeff$Values.CC, f20);
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

