/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.ShadeInfo;
import com.motivewave.platform.sdk.common.desc.BarDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.CCI$Signals;
import com.motivewave.platform.study.general.CCI$Values;

@StudyHeader(namespace="com.motivewave", id="CCI", rb="com.motivewave.platform.study.nls.strings", name="TITLE_CCI", label="LBL_CCI", desc="DESC_CCI", menu="MENU_GENERAL", overlay=false, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/commodity_channel_index.htm")
public class CCI
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new BarDescriptor("bar", this.get("LBL_HISTOGRAM", new Object[0]), defaults.getBarColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "topGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "bottomGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_ADVANCED", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 100.0, -9999.0, 9999.0, 1.0, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), -100.0, -9999.0, 9999.0, 1.0, true)});
        GuideDescriptor guideDescriptor = new GuideDescriptor("centerGuide", this.get("LBL_CENTER_GUIDE", new Object[0]), 0.0, -9999.0, 9999.0, 1.0, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line", "bar", "topFill", "bottomFill"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setMinTick(Double.valueOf(0.1));
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CCI$Values.CCI, this.get("LBL_CCI", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declarePath((Object)CCI$Values.CCI, "line");
        runtimeDescriptor.declareBars((Object)CCI$Values.CCI, "bar");
        runtimeDescriptor.declareIndicator((Object)CCI$Values.CCI, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{CCI$Values.CCI});
        runtimeDescriptor.declareSignal((Object)CCI$Signals.CCI_TOP, this.get("LBL_CCI_TOP", new Object[0]));
        runtimeDescriptor.declareSignal((Object)CCI$Signals.CCI_BOTTOM, this.get("LBL_CCI_BOTTOM", new Object[0]));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period", 20);
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        ShadeInfo shadeInfo = this.getSettings().getShade("topFill");
        ShadeInfo shadeInfo2 = this.getSettings().getShade("bottomFill");
        double[] dArray = new double[n3];
        int n4 = 0;
        double d2 = 0.0;
        for (int i2 = n2 - n3 + 1; i2 <= n2; ++i2) {
            dArray[n4] = dataSeries.getTypicalPrice(i2).floatValue();
            d2 += dArray[n4];
            ++n4;
        }
        double d3 = d2 / (double)n3;
        d2 = 0.0;
        for (int i3 = 0; i3 < dArray.length; ++i3) {
            d2 += Math.abs(dArray[i3] - d3);
        }
        double d4 = d2 / (double)n3;
        double d5 = (dArray[n3 - 1] - d3) / (0.015 * d4);
        dataSeries.setDouble(n2, (Object)CCI$Values.CCI, Double.valueOf(d5));
        if (shadeInfo.isEnabled() && d5 >= guideInfo.getValue()) {
            dataSeries.setBarColor(n2, (Object)CCI$Values.CCI, shadeInfo.getColor());
        } else if (shadeInfo2.isEnabled() && d5 <= guideInfo2.getValue()) {
            dataSeries.setBarColor(n2, (Object)CCI$Values.CCI, shadeInfo2.getColor());
        } else {
            dataSeries.setBarColor(n2, (Object)CCI$Values.CCI, null);
        }
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        d5 = this.round(d5);
        if (this.crossedAbove(dataSeries, n2, (Object)CCI$Values.CCI, guideInfo.getValue())) {
            dataContext.signal(n2, (Object)CCI$Signals.CCI_TOP, this.get("SIGNAL_CCI_TOP", new Object[]{d5, guideInfo.getValue()}), (Object)d5);
        } else if (this.crossedBelow(dataSeries, n2, (Object)CCI$Values.CCI, guideInfo2.getValue())) {
            dataContext.signal(n2, (Object)CCI$Signals.CCI_BOTTOM, this.get("SIGNAL_CCI_BOTTOM", new Object[]{d5, guideInfo2.getValue()}), (Object)d5);
        }
        dataSeries.setComplete(n2);
    }
}

