/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.BBPercentB$Values;

@StudyHeader(namespace="com.motivewave", id="BB_PERCENT", rb="com.motivewave.platform.study.nls.strings", name="TITLE_BB_PERCENT", label="LBL_BB_PERCENT", menu="MENU_GENERAL", desc="DESC_BB_PERCENT", overlay=false, studyOverlay=true, helpLink="http://www.motivewave.com/studies/bollinger_bands_b.htm")
public class BBPercentB
extends Study {
    static final String a = "stdDev";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("TAB_GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("LBL_STD_DEV", new Object[0]), 2.0, 0.1, 999.0, 0.1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "topGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "bottomGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("TAB_ADVANCED", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 1.0, -100.0, 100.0, 0.01, true)});
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("LBL_MIDDLE_GUIDE", new Object[0]), 0.5, -100.0, 100.0, 0.01, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup3.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), 0.0, -100.0, 100.0, 0.01, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{a, "line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BBPercentB$Values.PB, this.get("LBL_PB", new Object[0]), new String[]{"input", "period", a}));
        runtimeDescriptor.declarePath((Object)BBPercentB$Values.PB, "line");
        runtimeDescriptor.declareIndicator((Object)BBPercentB$Values.PB, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{BBPercentB$Values.PB});
        runtimeDescriptor.setMinTick(Double.valueOf(0.01));
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period", 20);
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        double d2 = this.getSettings().getDouble(a, 2.0);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = dataSeries.getDouble(n2, object);
        double d4 = dataSeries.sma(n2, n3, object);
        Double d5 = dataSeries.std(n2, n3, object) * d2;
        double d6 = d4 + d5;
        double d7 = d4 - d5;
        dataSeries.setDouble(n2, (Object)BBPercentB$Values.PB, Double.valueOf((d3 - d7) / (d6 - d7)));
        dataSeries.setComplete(n2);
    }
}

