/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.SliderDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.AGGZ$Signals;
import com.motivewave.platform.study.general.AGGZ$Values;

@StudyHeader(namespace="com.motivewave", id="ID_AGGZ", rb="com.motivewave.platform.study.nls.strings2", label="LBL_AGGZ", name="NAME_AGGZ", desc="DESC_AGGZ", helpLink="", signals=true, overlay=false, studyOverlay=true)
public class AGGZ
extends Study {
    private Marker a = null;
    private Marker b = null;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = this.createSD();
        SettingTab settingTab = settingsDescriptor.addTab(this.get("GENERAL", new Object[0]));
        SettingGroup settingGroup = settingTab.addGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("SHORT_PERIOD", new Object[0]), 10, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LONG_PERIOD", new Object[0]), 200, 1, 9999, 1)});
        SettingGroup settingGroup2 = settingTab.addGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab = settingsDescriptor.addTab(this.get("DISPLAY", new Object[0]));
        SettingGroup settingGroup3 = settingTab.addGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), -999.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup2 = settingTab.addGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        SettingGroup settingGroup4 = settingTab.addGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingsDescriptor.addQuickSettings(new String[]{"input", "method"});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period", this.get("SHORT_PERIOD", new Object[0]), 10, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new SettingDescriptor[]{new SliderDescriptor("period2", this.get("LONG_PERIOD", new Object[0]), 200, 1, 9999, true, () -> Enums.Icon.SINE_WAVE.get())});
        settingsDescriptor.addQuickSettings(new String[]{"line"});
        RuntimeDescriptor runtimeDescriptor = this.createRD();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)AGGZ$Values.AGGZ, this.get("LBL_AGGZ", new Object[0]), new String[]{"input", "method", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)AGGZ$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)AGGZ$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), new String[0]));
        runtimeDescriptor.declareSignal((Object)AGGZ$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)AGGZ$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)AGGZ$Values.AGGZ, "line");
        runtimeDescriptor.declareIndicator((Object)AGGZ$Values.AGGZ, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{AGGZ$Values.AGGZ});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        Marker marker;
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        if (n2 < n4) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getClose(n2);
        Double d3 = dataSeries.ma(mAMethod, n2, n3, object);
        Double d4 = dataSeries.ma(mAMethod, n2, n4, object);
        Double d5 = dataSeries.std(n2, n3, object);
        Double d6 = dataSeries.std(n2, n4, object);
        if (d3 == null || d4 == null || d5 == null || d6 == null) {
            return;
        }
        double d7 = (d2 - d3) / d5;
        double d8 = (d2 - d4) / d6;
        double d9 = -1.0 * (d7 + d8) / 2.0;
        dataSeries.setDouble(n2, (Object)AGGZ$Values.AGGZ, Double.valueOf(d9));
        GuideInfo guideInfo = this.getSettings().getGuide("middleGuide");
        double d10 = guideInfo.getValue();
        boolean bl2 = d9 < d10;
        boolean bl3 = d9 > d10;
        dataSeries.setBoolean(n2, (Object)AGGZ$Signals.BUY, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)AGGZ$Signals.SELL, Boolean.valueOf(bl2));
        Boolean bl4 = dataSeries.getBoolean(n2 - 1, (Object)AGGZ$Signals.BUY);
        Boolean bl5 = dataSeries.getBoolean(n2 - 1, (Object)AGGZ$Signals.SELL);
        if (bl4 == null || bl5 == null) {
            return;
        }
        long l2 = dataSeries.getStartTime(n2);
        this.a(l2);
        if (bl2 && !bl5.booleanValue()) {
            coordinate = new Coordinate(l2, d9);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_AGGZ", new Object[]{Util.round((double)d2, (int)3), Util.round((double)d9, (int)3)});
            if (markerInfo.isEnabled()) {
                marker = new Marker(coordinate, Enums.Position.TOP, markerInfo, string);
                this.addFigure((Figure)marker);
                this.a = marker;
            }
            dataContext.signal(n2, (Object)AGGZ$Signals.SELL, string, (Object)d2);
        }
        if (bl3 && !bl4.booleanValue()) {
            coordinate = new Coordinate(l2, d9);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_AGGZ", new Object[]{Util.round((double)d2, (int)3), Util.round((double)d9, (int)3)});
            if (markerInfo.isEnabled()) {
                marker = new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string);
                this.addFigure((Figure)marker);
                this.b = marker;
            }
            dataContext.signal(n2, (Object)AGGZ$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }

    private void a(long l2) {
        if (this.a != null && this.a.getTime() == l2) {
            this.removeFigure((Figure)this.a);
            this.a = null;
        }
        if (this.b != null && this.b.getTime() == l2) {
            this.removeFigure((Figure)this.b);
            this.b = null;
        }
    }
}

